/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.PriorityQueue;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorHeap<E extends Comparable<E>>
implements PriorityQueue<E> {
    protected Vector<E> data;

    public VectorHeap() {
        this.data = new Vector();
    }

    public VectorHeap(Vector<E> vector) {
        this.data = new Vector(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            this.add((Comparable)vector.get(i));
        }
    }

    protected static int parent(int n) {
        return (n - 1) / 2;
    }

    protected static int left(int n) {
        return 2 * n + 1;
    }

    protected static int right(int n) {
        return 2 * (n + 1);
    }

    @Override
    public E getFirst() {
        return (E)((Comparable)this.data.get(0));
    }

    @Override
    public E remove() {
        E e = this.getFirst();
        this.data.set(0, this.data.get(this.data.size() - 1));
        this.data.setSize(this.data.size() - 1);
        if (this.data.size() > 1) {
            this.pushDownRoot(0);
        }
        return e;
    }

    @Override
    public void add(E e) {
        this.data.add(e);
        this.percolateUp(this.data.size() - 1);
    }

    @Override
    public boolean isEmpty() {
        return this.data.size() == 0;
    }

    protected void percolateUp(int n) {
        int n2 = VectorHeap.parent(n);
        Comparable comparable = (Comparable)this.data.get(n);
        while (n > 0 && comparable.compareTo(this.data.get(n2)) < 0) {
            this.data.set(n, this.data.get(n2));
            n = n2;
            n2 = VectorHeap.parent(n);
        }
        this.data.set(n, comparable);
    }

    protected void pushDownRoot(int n) {
        int n2 = this.data.size();
        Comparable comparable = (Comparable)this.data.get(n);
        while (n < n2) {
            int n3 = VectorHeap.left(n);
            if (n3 < n2) {
                if (VectorHeap.right(n) < n2 && ((Comparable)this.data.get(n3 + 1)).compareTo(this.data.get(n3)) < 0) {
                    ++n3;
                }
                if (((Comparable)this.data.get(n3)).compareTo(comparable) < 0) {
                    this.data.set(n, this.data.get(n3));
                    n = n3;
                    continue;
                }
                this.data.set(n, comparable);
                return;
            }
            this.data.set(n, comparable);
            return;
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public String toString() {
        return "<VectorHeap: " + this.data + ">";
    }
}

