/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Collection;
import java.util.Iterator;
import structure5.AbstractList;
import structure5.Assert;
import structure5.VectorIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector<E>
extends AbstractList<E>
implements Cloneable {
    private Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    protected E initialValue;
    protected static final int defaultCapacity = 10;

    public Vector() {
        this(10);
    }

    public Vector(int n) {
        Assert.pre(n >= 0, "Capacity must not be negative");
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.capacityIncrement = 0;
        this.initialValue = null;
    }

    public Vector(int n, int n2) {
        Assert.pre(n >= 0, "Capacity must not be negative.");
        Assert.pre(n2 >= 0, "The capacity increment must be 0, for doubling, or positive for incremental growth.");
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.capacityIncrement = n2;
        this.initialValue = null;
    }

    public Vector(int n, int n2, E e) {
        Assert.pre(n >= 0, "Nonnegative capacity.");
        this.capacityIncrement = n2;
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.initialValue = e;
    }

    public Vector(Vector<E> vector) {
        this(vector.values());
    }

    public Vector(Collection<E> collection) {
        this(collection.size());
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void ensureCapacity(int n) {
        if (this.elementData.length < n) {
            int n2;
            if (this.capacityIncrement == 0) {
                if (n2 == 0) {
                    n2 = 1;
                }
                while (n2 < n) {
                    n2 *= 2;
                }
            } else {
                for (n2 = this.elementData.length; n2 < n; n2 += this.capacityIncrement) {
                }
            }
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < this.elementCount; ++i) {
                objectArray[i] = this.elementData[i];
            }
            this.elementData = objectArray;
        }
    }

    @Override
    public void add(E e) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount] = e;
        ++this.elementCount;
    }

    public void addElement(E e) {
        this.add(e);
    }

    @Override
    public E remove(E e) {
        E e2 = null;
        int n = this.indexOf(e);
        if (n >= 0) {
            e2 = this.get(n);
            this.remove(n);
        }
        return e2;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public Object clone() {
        Vector vector = null;
        try {
            vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.fail("Vector cannot be cloned.");
        }
        return vector;
    }

    @Override
    public boolean contains(E e) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (!e.equals(this.elementData[i])) continue;
            return true;
        }
        return false;
    }

    public void copyInto(Object[] objectArray) {
        for (int i = 0; i < this.elementCount; ++i) {
            objectArray[i] = this.elementData[i];
        }
    }

    public E elementAt(int n) {
        Assert.pre(0 <= n && n < this.size(), "index is within bounds");
        return this.get(n);
    }

    @Override
    public E get(int n) {
        return (E)this.elementData[n];
    }

    @Override
    public Iterator<E> iterator() {
        return new VectorIterator(this);
    }

    public E firstElement() {
        return this.get(0);
    }

    @Override
    public int indexOf(E e) {
        return this.indexOf(e, 0);
    }

    public int indexOf(E e, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!e.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public void insertElementAt(E e, int n) {
        this.add(n, e);
    }

    @Override
    public void add(int n, E e) {
        this.ensureCapacity(this.elementCount + 1);
        for (int i = this.elementCount; i > n; --i) {
            this.elementData[i] = this.elementData[i - 1];
        }
        this.elementData[n] = e;
        ++this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public E lastElement() {
        return this.get(this.elementCount - 1);
    }

    @Override
    public int lastIndexOf(E e) {
        return this.lastIndexOf(e, this.elementCount - 1);
    }

    public int lastIndexOf(E e, int n) {
        for (int i = n; i >= 0; --i) {
            if (!e.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.setSize(0);
    }

    public void removeAllElements() {
        this.setSize(0);
    }

    public void removeElementAt(int n) {
        this.remove(n);
    }

    @Override
    public E remove(int n) {
        E e = this.get(n);
        --this.elementCount;
        while (n < this.elementCount) {
            this.elementData[n] = this.elementData[n + 1];
            ++n;
        }
        this.elementData[this.elementCount] = null;
        return e;
    }

    public void setElementAt(E e, int n) {
        this.set(n, e);
    }

    @Override
    public E set(int n, E e) {
        Assert.pre(0 <= n && n < this.elementCount, "index is within bounds");
        Object object = this.elementData[n];
        this.elementData[n] = e;
        return (E)object;
    }

    public void setSize(int n) {
        if (n < this.elementCount) {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        } else {
            this.ensureCapacity(n);
            for (int i = this.elementCount; i < n; ++i) {
                this.elementData[i] = this.initialValue;
            }
        }
        this.elementCount = n;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    public void trimToSize() {
        Object[] objectArray = new Object[this.elementCount];
        this.copyInto(objectArray);
        this.elementData = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Vector:");
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(" " + this.get(i));
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

