/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractMap;
import structure5.Association;
import structure5.ComparableAssociation;
import structure5.KeyIterator;
import structure5.OrderedMap;
import structure5.OrderedStructure;
import structure5.ReadStream;
import structure5.Set;
import structure5.SetList;
import structure5.SinglyLinkedList;
import structure5.SplayTree;
import structure5.Structure;
import structure5.ValueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table<K extends Comparable<K>, V>
extends AbstractMap<K, V>
implements OrderedMap<K, V> {
    protected OrderedStructure<ComparableAssociation<K, V>> data = new SplayTree<ComparableAssociation<K, V>>();

    public Table() {
    }

    public Table(Table<K, V> table) {
        for (Association association : table.entrySet()) {
            this.put((K)((Comparable)association.getKey()), (V)association.getValue());
        }
    }

    @Override
    public V get(K k) {
        ComparableAssociation<K, Object> comparableAssociation = new ComparableAssociation<K, Object>(k, null);
        ComparableAssociation<K, Object> comparableAssociation2 = this.data.remove(comparableAssociation);
        if (comparableAssociation2 == null) {
            return null;
        }
        this.data.add(comparableAssociation2);
        return comparableAssociation2.getValue();
    }

    @Override
    public V put(K k, V v) {
        ComparableAssociation<K, V> comparableAssociation = new ComparableAssociation<K, V>(k, v);
        ComparableAssociation<K, V> comparableAssociation2 = this.data.remove(comparableAssociation);
        this.data.add(comparableAssociation);
        if (comparableAssociation2 == null) {
            return null;
        }
        return comparableAssociation2.getValue();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public Iterator<K> keys() {
        return new KeyIterator(this.data.iterator());
    }

    public Iterator<V> iterator() {
        return new ValueIterator(this.data.iterator());
    }

    @Override
    public boolean containsKey(K k) {
        ComparableAssociation<K, Object> comparableAssociation = new ComparableAssociation<K, Object>(k, null);
        return this.data.contains(comparableAssociation);
    }

    @Override
    public boolean containsValue(V v) {
        Iterator<V> iterator = this.iterator();
        while (iterator.hasNext()) {
            V v2 = iterator.next();
            if (v2 == null || !v2.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(K k) {
        ComparableAssociation<K, Object> comparableAssociation = new ComparableAssociation<K, Object>(k, null);
        if ((comparableAssociation = this.data.remove(comparableAssociation)) == null) {
            return null;
        }
        return comparableAssociation.getValue();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Set<K> keySet() {
        SetList setList = new SetList();
        KeyIterator keyIterator = new KeyIterator(this.data.iterator());
        while (keyIterator.hasNext()) {
            setList.add(keyIterator.next());
        }
        return setList;
    }

    @Override
    public Structure<V> values() {
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        ValueIterator valueIterator = new ValueIterator(this.data.iterator());
        while (valueIterator.hasNext()) {
            singlyLinkedList.add(valueIterator.next());
        }
        return singlyLinkedList;
    }

    @Override
    public Set<Association<K, V>> entrySet() {
        SetList<Association<K, V>> setList = new SetList<Association<K, V>>();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            setList.add((Association<K, V>)iterator.next());
        }
        return setList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Table: size=" + this.size());
        for (ComparableAssociation comparableAssociation : this.data) {
            stringBuffer.append(" key=" + comparableAssociation.getKey() + ", value=" + comparableAssociation.getValue());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Table<String, String> table = new Table<String, String>();
        ReadStream readStream = new ReadStream();
        System.out.println("Enter a word: ");
        while (!readStream.eof()) {
            String string = readStream.readLine();
            System.out.println("Enter a definition: ");
            String string2 = readStream.readLine();
            table.put(string, string2);
            System.out.println("Enter a word: ");
        }
        System.out.println(table);
    }
}

