/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import structure5.Assert;
import structure5.Structure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructCollection<E>
implements Collection<E> {
    protected Structure<E> base;

    public StructCollection(Structure<E> structure) {
        this.base = structure;
    }

    @Override
    public boolean add(E e) {
        this.base.add(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        this.base.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.base.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean bl;
        Iterator<?> iterator = collection.iterator();
        for (bl = true; bl && iterator.hasNext(); bl &= this.contains(iterator.next())) {
        }
        return bl;
    }

    @Override
    public boolean equals(Object object) {
        return this.base.equals(object);
    }

    @Override
    public int hashCode() {
        return this.base.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.base.iterator();
    }

    @Override
    public boolean remove(Object object) {
        Object object2 = this.base.remove(object);
        return object2 != null;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = true;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl &= this.remove(iterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Vector<E> vector = new Vector<E>();
        Iterator<E> iterator = this.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (collection.contains(e)) {
                vector.addElement(e);
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.clear();
            this.addAll(vector);
        }
        return bl;
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public Object[] toArray() {
        int n = this.size();
        Object[] objectArray = new Object[n];
        return this.toArray(objectArray);
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (n > objectArray.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator<E> iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext() && n2 < n) {
            objectArray[n2++] = iterator.next();
        }
        Assert.pre(!iterator.hasNext(), "Collection size() consistent with iterator.");
        if (n2 < n) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public String toString() {
        return "<StructCollection wrapping " + this.base + ">";
    }
}

