/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractStack;
import structure5.ArrayIterator;
import structure5.Assert;
import structure5.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackArray<E>
extends AbstractStack<E>
implements Stack<E> {
    protected int top;
    protected Object[] data;

    public StackArray(int n) {
        this.data = new Object[n];
        this.clear();
    }

    @Override
    public void clear() {
        this.top = -1;
    }

    @Override
    public void add(E e) {
        Assert.pre(!this.isFull(), "Stack is not full.");
        ++this.top;
        this.data[this.top] = e;
    }

    @Override
    public E remove() {
        Assert.pre(!this.isEmpty(), "Stack is not empty.");
        Object object = this.data[this.top];
        this.data[this.top] = null;
        --this.top;
        return (E)object;
    }

    @Override
    public E get() {
        Assert.pre(!this.isEmpty(), "Stack is not empty.");
        return (E)this.data[this.top];
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator(this.data, 0, this.size());
    }

    @Override
    public int size() {
        return this.top + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.top == this.data.length - 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<StackArray: ");
        for (int i = this.top; i >= 0; --i) {
            stringBuffer.append(" " + this.data[i]);
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

