/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;
import structure5.BinaryTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SplayTreeIterator<E extends Comparable<E>>
extends AbstractIterator<E> {
    protected BinaryTree<E> tree;
    protected final BinaryTree<E> LEAF;
    protected BinaryTree<E> current;

    public SplayTreeIterator(BinaryTree<E> binaryTree, BinaryTree<E> binaryTree2) {
        this.tree = binaryTree;
        this.LEAF = binaryTree2;
        this.reset();
    }

    @Override
    public void reset() {
        this.current = this.tree;
        if (!this.current.isEmpty()) {
            this.current = this.current.root();
            while (!this.current.left().isEmpty()) {
                this.current = this.current.left();
            }
        }
    }

    @Override
    public boolean hasNext() {
        return !this.current.isEmpty();
    }

    @Override
    public E next() {
        Comparable comparable = (Comparable)this.current.value();
        if (!this.current.right().isEmpty()) {
            this.current = this.current.right();
            while (!this.current.left().isEmpty()) {
                this.current = this.current.left();
            }
        } else {
            boolean bl;
            do {
                bl = this.current.isLeftChild();
                this.current = this.current.parent();
            } while (this.current != null && !bl);
            if (this.current == null) {
                this.current = new BinaryTree();
            }
        }
        return (E)comparable;
    }

    @Override
    public E get() {
        return (E)((Comparable)this.current.value());
    }
}

