/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Comparator;
import java.util.Iterator;
import structure5.BinarySearchTree;
import structure5.BinaryTree;
import structure5.NaturalComparator;
import structure5.OrderedStructure;
import structure5.SplayTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplayTree<E extends Comparable<E>>
extends BinarySearchTree<E>
implements OrderedStructure<E> {
    public SplayTree() {
        this(new NaturalComparator());
    }

    public SplayTree(Comparator<E> comparator) {
        super(comparator);
    }

    @Override
    public void add(E e) {
        BinaryTree<E> binaryTree = new BinaryTree<E>(e, this.EMPTY, this.EMPTY);
        if (this.root.isEmpty()) {
            this.root = binaryTree;
        } else {
            BinaryTree<E> binaryTree2 = this.locate(this.root, e);
            Comparable comparable = (Comparable)binaryTree2.value();
            if (this.ordering.compare(comparable, e) < 0) {
                binaryTree2.setRight(binaryTree);
            } else if (!binaryTree2.left().isEmpty()) {
                this.predecessor(binaryTree2).setRight(binaryTree);
            } else {
                binaryTree2.setLeft(binaryTree);
            }
            this.root = binaryTree;
            this.splay(this.root);
        }
        ++this.count;
    }

    @Override
    public boolean contains(E e) {
        if (this.root.isEmpty()) {
            return false;
        }
        BinaryTree<E> binaryTree = this.locate(this.root, e);
        if (e.equals(binaryTree.value())) {
            this.root = binaryTree;
            this.splay(this.root);
            return true;
        }
        return false;
    }

    @Override
    public E get(E e) {
        BinaryTree<E> binaryTree;
        if (this.root.isEmpty()) {
            return null;
        }
        this.root = binaryTree = this.locate(this.root, e);
        this.splay(this.root);
        if (e.equals(binaryTree.value())) {
            return (E)((Comparable)binaryTree.value());
        }
        return null;
    }

    @Override
    public E remove(E e) {
        if (this.isEmpty()) {
            return null;
        }
        if (e.equals(this.root.value())) {
            BinaryTree binaryTree = this.removeTop(this.root);
            --this.count;
            Comparable comparable = (Comparable)this.root.value();
            this.root = binaryTree;
            return (E)comparable;
        }
        BinaryTree<E> binaryTree = this.locate(this.root, e);
        if (e.equals(binaryTree.value())) {
            --this.count;
            BinaryTree<E> binaryTree2 = binaryTree.parent();
            if (binaryTree2.right() == binaryTree) {
                binaryTree2.setRight(this.removeTop(binaryTree));
            } else {
                binaryTree2.setLeft(this.removeTop(binaryTree));
            }
            this.root = binaryTree2;
            this.splay(this.root);
            return (E)((Comparable)binaryTree.value());
        }
        return null;
    }

    protected void splay(BinaryTree<E> binaryTree) {
        BinaryTree<E> binaryTree2;
        while ((binaryTree2 = binaryTree.parent()) != null) {
            BinaryTree<E> binaryTree3 = binaryTree2.parent();
            if (binaryTree3 == null) {
                if (binaryTree.isLeftChild()) {
                    binaryTree2.rotateRight();
                    continue;
                }
                binaryTree2.rotateLeft();
                continue;
            }
            if (binaryTree2.isLeftChild()) {
                if (binaryTree.isLeftChild()) {
                    binaryTree3.rotateRight();
                    binaryTree2.rotateRight();
                    continue;
                }
                binaryTree2.rotateLeft();
                binaryTree3.rotateRight();
                continue;
            }
            if (binaryTree.isRightChild()) {
                binaryTree3.rotateLeft();
                binaryTree2.rotateLeft();
                continue;
            }
            binaryTree2.rotateRight();
            binaryTree3.rotateLeft();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new SplayTreeIterator(this.root, this.EMPTY);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SplayTree: size=" + this.count + " root=" + this.root + ">");
        return stringBuffer.toString();
    }
}

