/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import java.util.Random;
import structure5.Assert;
import structure5.BinaryTree;
import structure5.MergeableHeap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkewHeap<E extends Comparable<E>>
implements MergeableHeap<E> {
    protected BinaryTree<E> root;
    protected final BinaryTree<E> EMPTY = new BinaryTree();
    protected int count = 0;

    public SkewHeap() {
        this.root = this.EMPTY;
    }

    @Override
    public E getFirst() {
        return (E)((Comparable)this.root.value());
    }

    @Override
    public E remove() {
        Comparable comparable = (Comparable)this.root.value();
        this.root = SkewHeap.merge(this.root.left(), this.root.right());
        --this.count;
        return (E)comparable;
    }

    @Override
    public void add(E e) {
        BinaryTree<E> binaryTree = new BinaryTree<E>(e, this.EMPTY, this.EMPTY);
        this.root = SkewHeap.merge(binaryTree, this.root);
        ++this.count;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void clear() {
        this.root = this.EMPTY;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void merge(MergeableHeap<E> mergeableHeap) {
        Assert.pre(mergeableHeap instanceof SkewHeap, "otherHeap must be instance of SkewHeap");
        SkewHeap skewHeap = (SkewHeap)mergeableHeap;
        this.root = SkewHeap.merge(this.root, skewHeap.root);
        skewHeap.root = null;
        this.count += skewHeap.count;
    }

    protected static <E extends Comparable<E>> BinaryTree<E> merge(BinaryTree<E> binaryTree, BinaryTree<E> binaryTree2) {
        BinaryTree<E> binaryTree3;
        if (binaryTree.isEmpty()) {
            return binaryTree2;
        }
        if (binaryTree2.isEmpty()) {
            return binaryTree;
        }
        Comparable comparable = (Comparable)binaryTree.value();
        Comparable comparable2 = (Comparable)binaryTree2.value();
        if (comparable2.compareTo(comparable) < 0) {
            binaryTree3 = SkewHeap.merge(binaryTree2, binaryTree);
        } else {
            binaryTree3 = binaryTree;
            if (binaryTree3.left().isEmpty()) {
                binaryTree3.setLeft(binaryTree2);
            } else {
                BinaryTree<E> binaryTree4 = binaryTree3.right();
                binaryTree3.setRight(binaryTree3.left());
                binaryTree3.setLeft(SkewHeap.merge(binaryTree4, binaryTree2));
            }
        }
        return binaryTree3;
    }

    public String toString() {
        if (this.root.isEmpty()) {
            return "<SkewHeap: >";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SkewHeap:");
        if (!this.root.isEmpty()) {
            Iterator<E> iterator = this.root.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(" " + iterator.next());
            }
        }
        return stringBuffer + ">";
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        try {
            while (n3 != 198) {
                int n5;
                Random random = new Random();
                n4 = 0;
                n = 0;
                n2 = 0;
                n3 = 0;
                SkewHeap<Integer> skewHeap = new SkewHeap<Integer>();
                SkewHeap<Integer> skewHeap2 = new SkewHeap<Integer>();
                n4 = random.nextInt(100);
                for (n5 = 0; n5 < n4; ++n5) {
                    skewHeap.add(new Integer(random.nextInt(1000)));
                }
                n4 = random.nextInt(100);
                for (n5 = 0; n5 < n4; ++n5) {
                    skewHeap2.add(new Integer(random.nextInt(1000)));
                }
                n = skewHeap.size();
                n2 = skewHeap2.size();
                skewHeap.merge(skewHeap2);
                n3 = skewHeap.size();
                Assert.condition(n + n2 == n3, "Trees merge with right sizes.");
                System.out.println(n + " : " + n2 + " : " + n3);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(n + " : " + n2 + " : " + n3);
        }
    }
}

