/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Enumeration;
import java.util.Iterator;
import structure5.AbstractList;
import structure5.Assert;
import structure5.Node;
import structure5.SinglyLinkedListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglyLinkedList<E>
extends AbstractList<E> {
    protected int count = 0;
    protected Node<E> head = null;

    @Override
    public void add(E e) {
        this.addLast(e);
    }

    @Override
    public void addFirst(E e) {
        this.head = new Node<E>(e, this.head);
        ++this.count;
    }

    @Override
    public E removeFirst() {
        Node<E> node = this.head;
        this.head = this.head.next();
        --this.count;
        return node.value();
    }

    @Override
    public void addLast(E e) {
        Node<E> node = new Node<E>(e, null);
        if (this.head != null) {
            Node<E> node2 = this.head;
            while (node2.next() != null) {
                node2 = node2.next();
            }
            node2.setNext(node);
        } else {
            this.head = node;
        }
        ++this.count;
    }

    @Override
    public E removeLast() {
        Node node = this.head;
        Node node2 = null;
        Assert.pre(this.head != null, "List is not empty.");
        while (node.next() != null) {
            node2 = node;
            node = node.next();
        }
        if (node2 == null) {
            this.head = null;
        } else {
            node2.setNext(null);
        }
        --this.count;
        return node.value();
    }

    @Override
    public E getFirst() {
        return this.head.value();
    }

    @Override
    public E getLast() {
        Node<E> node = this.head;
        Assert.condition(node != null, "List is not empty.");
        while (node != null && node.next() != null) {
            node = node.next();
        }
        return node.value();
    }

    @Override
    public boolean contains(E e) {
        Node<E> node;
        for (node = this.head; node != null && !node.value().equals(e); node = node.next()) {
        }
        return node != null;
    }

    @Override
    public E remove(E e) {
        Node<E> node;
        Node<E> node2 = null;
        for (node = this.head; node != null && !node.value().equals(e); node = node.next()) {
            node2 = node;
        }
        if (node != null) {
            if (node2 == null) {
                this.head = node.next();
            } else {
                node2.setNext(node.next());
            }
            --this.count;
            return node.value();
        }
        return null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void clear() {
        this.head = null;
        this.count = 0;
    }

    @Override
    public E get(int n) {
        if (n >= this.size()) {
            return null;
        }
        Node<E> node = this.head;
        while (n > 0) {
            node = node.next();
            --n;
        }
        return node.value();
    }

    @Override
    public E set(int n, E e) {
        if (n >= this.size()) {
            return null;
        }
        Node<E> node = this.head;
        while (n > 0) {
            node = node.next();
            --n;
        }
        E e2 = node.value();
        node.setValue(e);
        return e2;
    }

    @Override
    public void add(int n, E e) {
        Assert.pre(0 <= n && n <= this.size(), "Index in range.");
        if (n == this.size()) {
            this.addLast(e);
        } else if (n == 0) {
            this.addFirst(e);
        } else {
            Node<E> node = null;
            Node<E> node2 = this.head;
            while (n > 0) {
                node = node2;
                node2 = node2.next();
                --n;
            }
            Node<E> node3 = new Node<E>(e, node2);
            ++this.count;
            node.setNext(node3);
        }
    }

    @Override
    public E remove(int n) {
        Assert.pre(0 <= n && n < this.size(), "Index in range.");
        if (n == 0) {
            return this.removeFirst();
        }
        if (n == this.size() - 1) {
            return this.removeLast();
        }
        Node<E> node = null;
        Node<E> node2 = this.head;
        while (n > 0) {
            node = node2;
            node2 = node2.next();
            --n;
        }
        node.setNext(node2.next());
        --this.count;
        return node2.value();
    }

    @Override
    public int indexOf(E e) {
        int n = 0;
        Node<E> node = this.head;
        while (node != null && !node.value().equals(e)) {
            node = node.next();
            ++n;
        }
        if (node == null) {
            return -1;
        }
        return n;
    }

    @Override
    public int lastIndexOf(E e) {
        int n = -1;
        int n2 = 0;
        Node<E> node = this.head;
        while (node != null) {
            if (node.value().equals(e)) {
                n = n2;
            }
            node = node.next();
            ++n2;
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new SinglyLinkedListIterator<E>(this.head);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SinglyLinkedList:");
        Enumeration enumeration = (Enumeration)((Object)this.iterator());
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(" " + enumeration.nextElement());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

