/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractSet;
import structure5.Structure;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetVector<E>
extends AbstractSet<E> {
    protected Vector<E> data = new Vector();

    public SetVector() {
    }

    public SetVector(Structure<E> structure) {
        this();
        this.addAll(structure);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void add(E e) {
        if (!this.data.contains(e)) {
            this.data.add(e);
        }
    }

    @Override
    public E remove(E e) {
        return this.data.remove(e);
    }

    @Override
    public boolean contains(E e) {
        return this.data.contains(e);
    }

    @Override
    public boolean containsAll(Structure<E> structure) {
        Iterator<E> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            if (structure.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        SetVector<E> setVector = new SetVector<E>();
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            setVector.add(iterator.next());
        }
        return setVector;
    }

    @Override
    public void addAll(Structure<E> structure) {
        Iterator<E> iterator = structure.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public void retainAll(Structure<E> structure) {
        SetVector<E> setVector = new SetVector<E>();
        for (E e : this.data) {
            if (!structure.contains(e)) continue;
            setVector.add(e);
        }
        this.clear();
        this.addAll(setVector);
    }

    @Override
    public void removeAll(Structure<E> structure) {
        Iterator<E> iterator = structure.iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public String toString() {
        return "<SetVector: " + this.data + ">";
    }

    public static void main(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[]{"Doug", "Evan", "Feng"};
        String[] stringArray3 = new String[]{"Doug", "Feng", "Lida"};
        SetVector<String> setVector = new SetVector<String>();
        SetVector<String> setVector2 = new SetVector<String>();
        for (n = 0; n < stringArray2.length; ++n) {
            setVector.add(stringArray2[n]);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            setVector2.add(stringArray3[n]);
        }
        setVector.retainAll(setVector2);
        System.out.println(setVector);
    }
}

