/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractSet;
import structure5.List;
import structure5.SinglyLinkedList;
import structure5.Structure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetList<E>
extends AbstractSet<E> {
    protected List<E> data = new SinglyLinkedList();

    @Override
    public void clear() {
        this.data = new SinglyLinkedList();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void add(E e) {
        if (!this.data.contains(e)) {
            this.data.add(e);
        }
    }

    @Override
    public E remove(E e) {
        return this.data.remove(e);
    }

    @Override
    public boolean contains(E e) {
        return this.data.contains(e);
    }

    @Override
    public boolean containsAll(Structure<E> structure) {
        Iterator<E> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            if (structure.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        SetList<E> setList = new SetList<E>();
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            setList.add(iterator.next());
        }
        return setList;
    }

    @Override
    public void addAll(Structure<E> structure) {
        Iterator<E> iterator = structure.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public void retainAll(Structure<E> structure) {
        SetList<E> setList = new SetList<E>();
        for (E e : this.data) {
            if (!structure.contains(e)) continue;
            setList.add(e);
        }
        this.clear();
        this.addAll(setList);
    }

    @Override
    public void removeAll(Structure<E> structure) {
        Iterator<E> iterator = structure.iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public String toString() {
        return "<SetList: " + this.data + ">";
    }
}

