/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractStructure;
import structure5.OrderedStructure;
import structure5.RedBlackTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedBlackSearchTree<E extends Comparable<E>>
extends AbstractStructure<E>
implements OrderedStructure<E> {
    protected RedBlackTree<E> root = new RedBlackTree();
    protected int count = 0;

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public void clear() {
        this.root = new RedBlackTree();
        this.count = 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public int height() {
        return this.root.height();
    }

    @Override
    public void add(E e) {
        this.root = this.root.add(e);
        ++this.count;
    }

    @Override
    public E remove(E e) {
        if (this.root.contains(e)) {
            this.root = this.root.remove(e);
            --this.count;
            return e;
        }
        return null;
    }

    @Override
    public boolean contains(E e) {
        return this.root.contains(e);
    }

    public boolean isRedBlack() {
        return this.root.consistency();
    }

    @Override
    public Iterator<E> iterator() {
        return this.root.iterator();
    }

    public String treeString() {
        return this.root.treeString();
    }

    public String toString() {
        return this.root.toString();
    }

    @Override
    public int hashCode() {
        return this.root.hashCode();
    }
}

