/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;
import structure5.RedBlackTree;
import structure5.Stack;
import structure5.StackList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RedBlackIterator<E extends Comparable<E>>
extends AbstractIterator<E> {
    protected RedBlackTree<E> root;
    protected Stack<RedBlackTree<E>> todo = new StackList<RedBlackTree<E>>();

    public RedBlackIterator(RedBlackTree<E> redBlackTree) {
        this.root = redBlackTree;
        this.reset();
    }

    @Override
    public void reset() {
        this.todo.clear();
        RedBlackTree<E> redBlackTree = this.root;
        while (!redBlackTree.isEmpty()) {
            this.todo.push(redBlackTree);
            redBlackTree = redBlackTree.left();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    @Override
    public E get() {
        return this.todo.get().value();
    }

    @Override
    public E next() {
        RedBlackTree<E> redBlackTree = this.todo.pop();
        E e = redBlackTree.value();
        if (!redBlackTree.right().isEmpty()) {
            RedBlackTree<E> redBlackTree2 = redBlackTree.right();
            do {
                this.todo.push(redBlackTree2);
            } while (!(redBlackTree2 = redBlackTree2.left()).isEmpty());
        }
        return e;
    }
}

