/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractQueue;
import structure5.ArrayIterator;
import structure5.Assert;
import structure5.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueArray<E>
extends AbstractQueue<E>
implements Queue<E> {
    protected Object[] data;
    protected int head;
    protected int count;

    public QueueArray(int n) {
        this.data = new Object[n];
        this.head = 0;
        this.count = 0;
    }

    @Override
    public void add(E e) {
        Assert.pre(!this.isFull(), "Queue is not full.");
        int n = (this.head + this.count) % this.data.length;
        this.data[n] = e;
        ++this.count;
    }

    @Override
    public E remove() {
        Assert.pre(!this.isEmpty(), "The queue is not empty.");
        Object object = this.data[this.head];
        this.head = (this.head + 1) % this.data.length;
        --this.count;
        return (E)object;
    }

    @Override
    public E get() {
        Assert.pre(!this.isEmpty(), "The queue is not empty.");
        return (E)this.data[this.head];
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void clear() {
        this.count = 0;
        this.head = 0;
    }

    public boolean isFull() {
        return this.count == this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator(this.data, this.head, this.count);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<QueueArray:");
        int n = this.head;
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append(" " + this.data[n]);
            n = (n + 1) % this.data.length;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

