/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.Assert;
import structure5.PriorityQueue;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityVector<E extends Comparable<E>>
implements PriorityQueue<E> {
    protected Vector<E> data = new Vector();

    @Override
    public E getFirst() {
        return (E)((Comparable)this.data.get(0));
    }

    @Override
    public E remove() {
        return (E)((Comparable)this.data.remove(0));
    }

    @Override
    public void add(E e) {
        int n = this.indexOf(e);
        this.data.add(n, e);
    }

    protected int indexOf(E e) {
        int n = 0;
        int n2 = this.data.size();
        int n3 = (n + n2) / 2;
        while (n < n2) {
            Assert.condition(n3 < n2, "Middle element exists.");
            Comparable comparable = (Comparable)this.data.get(n3);
            if (comparable.compareTo(e) < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = (n + n2) / 2;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.data.size() == 0;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public String toString() {
        return "<PriorityVector: " + this.data + ">";
    }
}

