/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractStructure;
import structure5.OrderedStructure;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedVector<E extends Comparable<E>>
extends AbstractStructure<E>
implements OrderedStructure<E> {
    protected Vector<E> data = new Vector();

    @Override
    public void add(E e) {
        int n = this.locate(e);
        this.data.add(n, e);
    }

    @Override
    public boolean contains(E e) {
        int n = this.locate(e);
        return n < this.size() && ((Comparable)this.data.get(n)).equals(e);
    }

    @Override
    public E remove(E e) {
        if (this.contains(e)) {
            int n = this.locate(e);
            Comparable comparable = (Comparable)this.data.get(n);
            this.data.remove(n);
            return (E)comparable;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.data.size() == 0;
    }

    @Override
    public void clear() {
        this.data.setSize(0);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    protected int locate(E e) {
        int n = 0;
        int n2 = this.data.size();
        int n3 = (n + n2) / 2;
        while (n < n2) {
            Comparable comparable = (Comparable)this.data.get(n3);
            if (comparable.compareTo(e) < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = (n + n2) / 2;
        }
        return n;
    }

    public String toString() {
        return "<OrderedVector: " + this.data + ">";
    }
}

