/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Comparator;
import java.util.Iterator;
import structure5.AbstractStructure;
import structure5.NaturalComparator;
import structure5.Node;
import structure5.OrderedStructure;
import structure5.SinglyLinkedListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedList<E extends Comparable<E>>
extends AbstractStructure<E>
implements OrderedStructure<E> {
    protected Node<E> data;
    protected int count;
    protected Comparator<? super E> ordering;

    public OrderedList() {
        this(new NaturalComparator());
    }

    public OrderedList(Comparator<? super E> comparator) {
        this.ordering = comparator;
        this.clear();
    }

    @Override
    public void clear() {
        this.data = null;
        this.count = 0;
    }

    @Override
    public void add(E e) {
        Node<E> node = null;
        for (Node<E> node2 = this.data; node2 != null && this.ordering.compare(node2.value(), e) < 0; node2 = node2.next()) {
            node = node2;
        }
        if (node == null) {
            this.data = new Node<E>(e, this.data);
        } else {
            node.setNext(new Node<E>(e, node.next()));
        }
        ++this.count;
    }

    @Override
    public boolean contains(E e) {
        Node<E> node;
        for (node = this.data; node != null && this.ordering.compare(node.value(), e) < 0; node = node.next()) {
        }
        return node != null && e.equals(node.value());
    }

    @Override
    public E remove(E e) {
        Node<E> node;
        Node<E> node2 = null;
        for (node = this.data; node != null && this.ordering.compare(node.value(), e) < 0; node = node.next()) {
            node2 = node;
        }
        if (node != null && e.equals(node.value())) {
            if (node2 == null) {
                this.data = node.next();
            } else {
                node2.setNext(node.next());
            }
            --this.count;
            return (E)((Comparable)node.value());
        }
        return null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new SinglyLinkedListIterator<E>(this.data);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<OrderedList:");
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" " + iterator.next());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

