/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.Assert;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matrix<E> {
    protected int height;
    protected int width;
    protected Vector<Vector<E>> rows;

    public Matrix() {
        this(0, 0);
    }

    public Matrix(int n, int n2) {
        this.height = n;
        this.width = n2;
        this.rows = new Vector(this.height);
        for (int i = 0; i < this.height; ++i) {
            Vector<Object> vector = new Vector<Object>(this.width);
            this.rows.add(vector);
            for (int j = 0; j < this.width; ++j) {
                vector.add(null);
            }
        }
    }

    public E get(int n, int n2) {
        Assert.pre(0 <= n && n < this.height, "Row in bounds.");
        Assert.pre(0 <= n2 && n2 < this.width, "Col in bounds.");
        return this.rows.get(n).get(n2);
    }

    public void set(int n, int n2, E e) {
        Assert.pre(0 <= n && n < this.height, "Row in bounds.");
        Assert.pre(0 <= n2 && n2 < this.width, "Col in bounds.");
        this.rows.get(n).set(n2, e);
    }

    public void addRow(int n) {
        Assert.pre(0 <= n && n < this.width, "Row in bounds.");
        ++this.height;
        Vector<Object> vector = new Vector<Object>(this.width);
        for (int i = 0; i < this.width; ++i) {
            vector.add(null);
        }
        this.rows.add(n, vector);
    }

    public void addCol(int n) {
        Assert.pre(0 <= n && n < this.width, "Col in bounds.");
        ++this.width;
        for (int i = 0; i < this.height; ++i) {
            this.rows.get(i).add(n, null);
        }
    }

    public Vector<E> removeRow(int n) {
        Assert.pre(0 <= n && n < this.height, "There is a row to be removed.");
        Vector<E> vector = this.rows.get(n);
        --this.height;
        this.rows.remove(n);
        return vector;
    }

    public Vector<E> removeCol(int n) {
        Assert.pre(0 <= n && n < this.width, "There is a column to be removed.");
        Vector<E> vector = new Vector<E>(this.height);
        --this.width;
        for (int i = 0; i < this.height; ++i) {
            Vector<E> vector2 = this.rows.get(i);
            vector.add(vector2.get(n));
            vector2.remove(n);
        }
        return vector;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Matrix:\n");
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                stringBuffer.append("  <Row " + i + ", Col " + j + ", value=");
                stringBuffer.append(this.get(i, j) + ">");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

