/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.Association;
import structure5.List;
import structure5.Map;
import structure5.Set;
import structure5.SetList;
import structure5.SinglyLinkedList;
import structure5.Structure;
import structure5.ValueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapList<K, V>
implements Map<K, V> {
    protected List<Association<K, V>> data = new SinglyLinkedList<Association<K, V>>();

    public MapList() {
    }

    public MapList(Map<K, V> map) {
        this();
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(K k) {
        return this.data.contains(new Association<K, Object>(k, null));
    }

    @Override
    public boolean containsValue(V v) {
        ValueIterator valueIterator = new ValueIterator(this.data.iterator());
        while (valueIterator.hasNext()) {
            Object e = valueIterator.next();
            if (e == null || !v.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(K k) {
        int n = this.data.indexOf(new Association<K, Object>(k, null));
        if (n >= 0) {
            return this.data.get(n).getValue();
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        Association<K, V> association = new Association<K, V>(k, v);
        Association<K, V> association2 = this.data.remove(association);
        this.data.add(association);
        if (association2 == null) {
            return null;
        }
        return association2.getValue();
    }

    @Override
    public V remove(K k) {
        Association<K, Object> association = this.data.remove(new Association<K, Object>(k, null));
        if (association == null) {
            return null;
        }
        return association.getValue();
    }

    @Override
    public void putAll(Map<K, V> map) {
        for (Association association : map.entrySet()) {
            this.put(association.getKey(), association.getValue());
        }
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Set<K> keySet() {
        SetList<K> setList = new SetList<K>();
        for (Association<K, V> association : this.data) {
            setList.add(association.getKey());
        }
        return setList;
    }

    @Override
    public Structure<V> values() {
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        ValueIterator valueIterator = new ValueIterator(this.data.iterator());
        while (valueIterator.hasNext()) {
            singlyLinkedList.add(valueIterator.next());
        }
        return singlyLinkedList;
    }

    @Override
    public Set<Association<K, V>> entrySet() {
        SetList<Association<K, V>> setList = new SetList<Association<K, V>>();
        for (Association<K, V> association : this.data) {
            setList.add(association);
        }
        return setList;
    }

    @Override
    public boolean equals(Object object) {
        MapList mapList = (MapList)object;
        return this.data.equals(mapList.data);
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }
}

