/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;
import structure5.Association;
import structure5.HashAssociation;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashtableIterator<K, V>
extends AbstractIterator<Association<K, V>> {
    protected int current;
    protected Vector<HashAssociation<K, V>> data;

    public HashtableIterator(Vector<HashAssociation<K, V>> vector) {
        this.data = vector;
        this.reset();
    }

    @Override
    public void reset() {
        this.current = 0;
        while (this.current < this.data.size() && (this.data.get(this.current) == null || this.data.get(this.current).reserved())) {
            ++this.current;
        }
    }

    @Override
    public boolean hasNext() {
        return this.current < this.data.size();
    }

    @Override
    public HashAssociation<K, V> next() {
        HashAssociation<K, V> hashAssociation = this.data.get(this.current);
        ++this.current;
        while (this.current < this.data.size() && (this.data.get(this.current) == null || this.data.get(this.current).reserved())) {
            ++this.current;
        }
        return hashAssociation;
    }

    @Override
    public Association<K, V> get() {
        return this.data.get(this.current);
    }
}

