/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractIterator;
import structure5.Assert;
import structure5.Association;
import structure5.HashAssociation;
import structure5.HashtableIterator;
import structure5.KeyIterator;
import structure5.Map;
import structure5.Set;
import structure5.SetList;
import structure5.SinglyLinkedList;
import structure5.Structure;
import structure5.ValueIterator;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<K, V>
implements Map<K, V>,
Iterable<V> {
    protected static final String RESERVED = "RESERVED";
    protected Vector<HashAssociation<K, V>> data;
    protected int count;
    protected final double maximumLoadFactor = 0.6;

    public Hashtable(int n) {
        Assert.pre(n > 0, "Hashtable capacity must be positive.");
        this.data = new Vector();
        this.data.setSize(n);
        this.count = 0;
    }

    public Hashtable() {
        this(997);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.set(i, null);
        }
        this.count = 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(V v) {
        for (V v2 : this) {
            if (!v2.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(K k) {
        int n = this.locate(k);
        return this.data.get(n) != null && !this.data.get(n).reserved();
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueIterator(new HashtableIterator<K, V>(this.data));
    }

    @Override
    public V get(K k) {
        int n = this.locate(k);
        if (this.data.get(n) == null || this.data.get(n).reserved()) {
            return null;
        }
        return this.data.get(n).getValue();
    }

    public Iterator<K> keys() {
        return new KeyIterator(new HashtableIterator<K, V>(this.data));
    }

    protected int locate(K k) {
        int n = Math.abs(k.hashCode() % this.data.size());
        int n2 = -1;
        boolean bl = false;
        while (this.data.get(n) != null) {
            if (this.data.get(n).reserved()) {
                if (!bl) {
                    n2 = n;
                    bl = true;
                }
            } else if (k.equals(this.data.get(n).getKey())) {
                return n;
            }
            n = (1 + n) % this.data.size();
        }
        if (!bl) {
            return n;
        }
        return n2;
    }

    @Override
    public V put(K k, V v) {
        int n;
        if (0.6 * (double)this.data.size() <= (double)(1 + this.count)) {
            this.extend();
        }
        if (this.data.get(n = this.locate(k)) == null || this.data.get(n).reserved()) {
            this.data.set(n, new HashAssociation<K, V>(k, v));
            ++this.count;
            return null;
        }
        HashAssociation<K, V> hashAssociation = this.data.get(n);
        V v2 = hashAssociation.getValue();
        hashAssociation.setValue(v);
        return v2;
    }

    @Override
    public void putAll(Map<K, V> map) {
        for (Association association : map.entrySet()) {
            this.put(association.getKey(), association.getValue());
        }
    }

    @Override
    public V remove(K k) {
        int n = this.locate(k);
        if (this.data.get(n) == null || this.data.get(n).reserved()) {
            return null;
        }
        --this.count;
        V v = this.data.get(n).getValue();
        this.data.get(n).reserve();
        return v;
    }

    protected void extend() {
        HashtableIterator<K, V> hashtableIterator = new HashtableIterator<K, V>(this.data);
        int n = 2 * this.data.size();
        Assert.condition(n > 0, "Hashtable vector size must be greater than 0.");
        this.data = new Vector();
        this.data.setSize(n);
        this.count = 0;
        while (((AbstractIterator)hashtableIterator).hasNext()) {
            Association association = (Association)((AbstractIterator)hashtableIterator).next();
            this.put(association.getKey(), association.getValue());
        }
    }

    @Override
    public Set<Association<K, V>> entrySet() {
        SetList<Association<K, V>> setList = new SetList<Association<K, V>>();
        HashtableIterator<K, V> hashtableIterator = new HashtableIterator<K, V>(this.data);
        while (hashtableIterator.hasNext()) {
            setList.add((Association<K, V>)hashtableIterator.next());
        }
        return setList;
    }

    @Override
    public Set<K> keySet() {
        SetList setList = new SetList();
        KeyIterator keyIterator = new KeyIterator(new HashtableIterator<K, V>(this.data));
        while (keyIterator.hasNext()) {
            setList.add(keyIterator.next());
        }
        return setList;
    }

    @Override
    public Structure<V> values() {
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        ValueIterator valueIterator = new ValueIterator(new HashtableIterator<K, V>(this.data));
        while (valueIterator.hasNext()) {
            singlyLinkedList.add(valueIterator.next());
        }
        return singlyLinkedList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Hashtable: size=" + this.size() + " capacity=" + this.data.size());
        HashtableIterator<K, V> hashtableIterator = new HashtableIterator<K, V>(this.data);
        while (hashtableIterator.hasNext()) {
            Association association = (Association)hashtableIterator.next();
            stringBuffer.append(" key=" + association.getKey() + ", value=" + association.getValue());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

