/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.Assert;
import structure5.Association;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashAssociation<K, V>
extends Association<K, V> {
    protected boolean reserved = false;

    public HashAssociation(K k, V v) {
        super(k, v);
    }

    public HashAssociation(K k) {
        this(k, null);
    }

    @Override
    public V getValue() {
        Assert.pre(!this.reserved, "Reserved HashAssociations may not be read.");
        return super.getValue();
    }

    @Override
    public K getKey() {
        Assert.pre(!this.reserved, "Reserved HashAssociations may not be read.");
        return super.getKey();
    }

    @Override
    public V setValue(V v) {
        Assert.pre(!this.reserved, "Reserved HashAssociations may not be written.");
        return super.setValue(v);
    }

    public boolean reserved() {
        return this.reserved;
    }

    public void reserve() {
        Assert.pre(!this.reserved, "HashAssociation reserved twice.");
        this.reserved = true;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.reserved()) {
            stringBuffer.append("<ReservedAssociation: RESERVED>");
        } else {
            stringBuffer.append("<ReservedAssociation: " + this.getKey() + "=" + this.getValue() + ">");
        }
        return stringBuffer.toString();
    }
}

