/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.Edge;
import structure5.GraphMatrix;
import structure5.GraphMatrixVertex;
import structure5.SinglyLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphMatrixUndirected<V, E>
extends GraphMatrix<V, E> {
    public GraphMatrixUndirected(int n) {
        super(n, false);
    }

    @Override
    public void addEdge(V v, V v2, E e) {
        Edge edge;
        GraphMatrixVertex graphMatrixVertex = (GraphMatrixVertex)this.dict.get(v);
        GraphMatrixVertex graphMatrixVertex2 = (GraphMatrixVertex)this.dict.get(v2);
        this.data[graphMatrixVertex.index()][graphMatrixVertex2.index()] = edge = new Edge(graphMatrixVertex.label(), graphMatrixVertex2.label(), e, false);
        this.data[graphMatrixVertex2.index()][graphMatrixVertex.index()] = edge;
    }

    @Override
    public E removeEdge(V v, V v2) {
        int n = ((GraphMatrixVertex)this.dict.get(v)).index();
        int n2 = ((GraphMatrixVertex)this.dict.get(v2)).index();
        Edge edge = (Edge)this.data[n][n2];
        this.data[n][n2] = null;
        this.data[n2][n] = null;
        if (edge == null) {
            return null;
        }
        return edge.label();
    }

    @Override
    public int edgeCount() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            for (int j = i; j < this.size; ++j) {
                if (this.data[i][j] == null) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public Iterator<Edge<V, E>> edges() {
        SinglyLinkedList<Edge> singlyLinkedList = new SinglyLinkedList<Edge>();
        for (int i = this.size - 1; i >= 0; --i) {
            for (int j = this.size - 1; j >= i; --j) {
                Edge edge = (Edge)this.data[i][j];
                if (edge == null) continue;
                singlyLinkedList.add(edge);
            }
        }
        return singlyLinkedList.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("<GraphMatrixUndirected:");
        while (iterator.hasNext()) {
            Object v = iterator.next();
            stringBuffer.append(" (" + v + "->");
            Iterator iterator2 = this.neighbors(v);
            while (iterator2.hasNext()) {
                stringBuffer.append(v + "->" + iterator2.next());
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

