/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractStructure;
import structure5.Assert;
import structure5.Edge;
import structure5.Graph;
import structure5.GraphMatrixVertex;
import structure5.Hashtable;
import structure5.List;
import structure5.Map;
import structure5.SinglyLinkedList;
import structure5.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphMatrix<V, E>
extends AbstractStructure<V>
implements Graph<V, E> {
    protected int size;
    protected Object[][] data;
    protected Map<V, GraphMatrixVertex<V>> dict;
    protected List<Integer> freeList;
    protected boolean directed;

    protected GraphMatrix(int n, boolean bl) {
        this.size = n;
        this.directed = bl;
        this.data = new Object[n][n];
        this.dict = new Hashtable<V, GraphMatrixVertex<V>>(n);
        this.freeList = new SinglyLinkedList<Integer>();
        for (int i = n - 1; i >= 0; --i) {
            this.freeList.add(new Integer(i));
        }
    }

    @Override
    public void add(V v) {
        if (this.dict.containsKey(v)) {
            return;
        }
        Assert.pre(!this.freeList.isEmpty(), "Matrix not full");
        int n = this.freeList.removeFirst();
        this.dict.put((GraphMatrixVertex<V>)v, (GraphMatrixVertex<GraphMatrixVertex<V>>)new GraphMatrixVertex<V>(v, n));
    }

    @Override
    public abstract void addEdge(V var1, V var2, E var3);

    @Override
    public V remove(V v) {
        GraphMatrixVertex<V> graphMatrixVertex = this.dict.remove(v);
        if (graphMatrixVertex == null) {
            return null;
        }
        int n = graphMatrixVertex.index();
        for (int i = 0; i < this.size; ++i) {
            this.data[i][n] = null;
            this.data[n][i] = null;
        }
        this.freeList.add(new Integer(n));
        return (V)graphMatrixVertex.label();
    }

    @Override
    public abstract E removeEdge(V var1, V var2);

    @Override
    public V get(V v) {
        GraphMatrixVertex<V> graphMatrixVertex = this.dict.get(v);
        return (V)graphMatrixVertex.label();
    }

    @Override
    public Edge<V, E> getEdge(V v, V v2) {
        int n = this.dict.get(v).index();
        int n2 = this.dict.get(v2).index();
        return (Edge)this.data[n][n2];
    }

    @Override
    public boolean contains(V v) {
        return this.dict.containsKey(v);
    }

    @Override
    public boolean containsEdge(V v, V v2) {
        GraphMatrixVertex<V> graphMatrixVertex = this.dict.get(v);
        GraphMatrixVertex<V> graphMatrixVertex2 = this.dict.get(v2);
        Assert.condition(graphMatrixVertex != null, "Vertex exists");
        Assert.condition(graphMatrixVertex2 != null, "Vertex exists");
        return this.data[graphMatrixVertex.index()][graphMatrixVertex2.index()] != null;
    }

    @Override
    public boolean visit(V v) {
        Vertex vertex = this.dict.get(v);
        return vertex.visit();
    }

    @Override
    public boolean visitEdge(Edge<V, E> edge) {
        return edge.visit();
    }

    @Override
    public boolean isVisited(V v) {
        GraphMatrixVertex<V> graphMatrixVertex = this.dict.get(v);
        return graphMatrixVertex.isVisited();
    }

    @Override
    public boolean isVisitedEdge(Edge<V, E> edge) {
        return edge.isVisited();
    }

    @Override
    public void reset() {
        Iterator<GraphMatrixVertex<V>> iterator = this.dict.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
        }
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                Edge edge = (Edge)this.data[i][j];
                if (edge == null) continue;
                edge.reset();
            }
        }
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public int degree(V v) {
        int n = this.dict.get(v).index();
        int n2 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[n][i] == null) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public abstract int edgeCount();

    @Override
    public Iterator<V> iterator() {
        return this.dict.keySet().iterator();
    }

    @Override
    public Iterator<V> neighbors(V v) {
        GraphMatrixVertex<V> graphMatrixVertex = this.dict.get(v);
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        for (int i = this.size - 1; i >= 0; --i) {
            Edge edge = (Edge)this.data[graphMatrixVertex.index()][i];
            if (edge == null) continue;
            if (edge.here().equals(graphMatrixVertex.label())) {
                singlyLinkedList.add(edge.there());
                continue;
            }
            singlyLinkedList.add(edge.here());
        }
        return singlyLinkedList.iterator();
    }

    @Override
    public abstract Iterator<Edge<V, E>> edges();

    @Override
    public void clear() {
        int n;
        this.dict.clear();
        for (n = 0; n < this.size; ++n) {
            for (int i = 0; i < this.size; ++i) {
                this.data[n][i] = null;
            }
        }
        this.freeList = new SinglyLinkedList<Integer>();
        for (n = this.size - 1; n >= 0; --n) {
            this.freeList.add(new Integer(n));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.dict.isEmpty();
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }
}

