/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.Edge;
import structure5.GraphListAIterator;
import structure5.SinglyLinkedList;
import structure5.Structure;
import structure5.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphListVertex<V, E>
extends Vertex<V> {
    protected Structure<Edge<V, E>> adjacencies = new SinglyLinkedList<Edge<V, E>>();

    public GraphListVertex(V v) {
        super(v);
    }

    public void addEdge(Edge<V, E> edge) {
        if (!this.containsEdge(edge)) {
            this.adjacencies.add(edge);
        }
    }

    public boolean containsEdge(Edge<V, E> edge) {
        return this.adjacencies.contains(edge);
    }

    public Edge<V, E> removeEdge(Edge<V, E> edge) {
        return this.adjacencies.remove(edge);
    }

    public Edge<V, E> getEdge(Edge<V, E> edge) {
        for (Edge<V, E> edge2 : this.adjacencies) {
            if (!edge.equals(edge2)) continue;
            return edge2;
        }
        return null;
    }

    public int degree() {
        return this.adjacencies.size();
    }

    public Iterator<V> adjacentVertices() {
        return new GraphListAIterator<V, E>(this.adjacentEdges(), this.label());
    }

    public Iterator<Edge<V, E>> adjacentEdges() {
        return this.adjacencies.iterator();
    }

    @Override
    public String toString() {
        return "<GraphListVertex: " + this.label() + ">";
    }
}

