/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.Edge;
import structure5.GraphList;
import structure5.GraphListVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphListUndirected<V, E>
extends GraphList<V, E> {
    public GraphListUndirected() {
        super(false);
    }

    @Override
    public void addEdge(V v, V v2, E e) {
        GraphListVertex graphListVertex = (GraphListVertex)this.dict.get(v);
        GraphListVertex graphListVertex2 = (GraphListVertex)this.dict.get(v2);
        Edge edge = new Edge(graphListVertex.label(), graphListVertex2.label(), e, false);
        graphListVertex.addEdge(edge);
        graphListVertex2.addEdge(edge);
    }

    @Override
    public V remove(V v) {
        GraphListVertex graphListVertex = (GraphListVertex)this.dict.get(v);
        Iterator<V> iterator = this.neighbors(v);
        while (iterator.hasNext()) {
            V v2 = iterator.next();
            this.removeEdge(v, v2);
        }
        this.dict.remove(v);
        return (V)graphListVertex.label();
    }

    @Override
    public E removeEdge(V v, V v2) {
        GraphListVertex graphListVertex = (GraphListVertex)this.dict.get(v);
        GraphListVertex graphListVertex2 = (GraphListVertex)this.dict.get(v2);
        Edge edge = new Edge(graphListVertex.label(), graphListVertex2.label(), null, false);
        graphListVertex2.removeEdge(edge);
        edge = graphListVertex.removeEdge(edge);
        if (edge == null) {
            return null;
        }
        return edge.label();
    }

    @Override
    public int edgeCount() {
        int n = 0;
        Iterator iterator = this.dict.values().iterator();
        while (iterator.hasNext()) {
            n += ((GraphListVertex)iterator.next()).degree();
        }
        return n / 2;
    }

    public String toString() {
        return "<GraphListUndirected: " + this.dict.toString() + ">";
    }
}

