/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractIterator;
import structure5.DoublyLinkedList;
import structure5.Edge;
import structure5.GraphListVertex;
import structure5.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphListEIterator<V, E>
extends AbstractIterator<Edge<V, E>> {
    protected AbstractIterator<Edge<V, E>> edges;

    public GraphListEIterator(Map<V, GraphListVertex<V, E>> map) {
        DoublyLinkedList<Edge<V, E>> doublyLinkedList = new DoublyLinkedList<Edge<V, E>>();
        for (GraphListVertex<V, E> graphListVertex : map.values()) {
            Iterator<Edge<V, E>> iterator = graphListVertex.adjacentEdges();
            while (iterator.hasNext()) {
                Edge<V, E> edge = iterator.next();
                if (!graphListVertex.label().equals(edge.here())) continue;
                doublyLinkedList.addLast(edge);
            }
        }
        this.edges = (AbstractIterator)doublyLinkedList.iterator();
    }

    @Override
    public void reset() {
        this.edges.reset();
    }

    @Override
    public boolean hasNext() {
        return this.edges.hasNext();
    }

    @Override
    public Edge<V, E> get() {
        return this.edges.get();
    }

    @Override
    public Edge<V, E> next() {
        return this.edges.next();
    }
}

