/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractStructure;
import structure5.Assert;
import structure5.Association;
import structure5.ComparableAssociation;
import structure5.Edge;
import structure5.Graph;
import structure5.GraphListDirected;
import structure5.GraphListEIterator;
import structure5.GraphListVertex;
import structure5.Hashtable;
import structure5.Map;
import structure5.SkewHeap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphList<V, E>
extends AbstractStructure<V>
implements Graph<V, E> {
    protected Map<V, GraphListVertex<V, E>> dict = new Hashtable<V, GraphListVertex<V, E>>();
    protected boolean directed;

    protected GraphList(boolean bl) {
        this.directed = bl;
    }

    @Override
    public void add(V v) {
        if (this.dict.containsKey(v)) {
            return;
        }
        GraphListVertex graphListVertex = new GraphListVertex(v);
        this.dict.put(v, graphListVertex);
    }

    @Override
    public abstract void addEdge(V var1, V var2, E var3);

    @Override
    public abstract V remove(V var1);

    @Override
    public abstract E removeEdge(V var1, V var2);

    @Override
    public V get(V v) {
        Assert.condition(this.dict.containsKey(v), "Vertex exists");
        return (V)this.dict.get(v).label();
    }

    @Override
    public Edge<V, E> getEdge(V v, V v2) {
        Assert.condition(this.dict.containsKey(v), "Vertex exists");
        Edge<V, Object> edge = new Edge<V, Object>(this.get(v), this.get(v2), null, this.directed);
        return this.dict.get(v).getEdge(edge);
    }

    @Override
    public boolean contains(V v) {
        return this.dict.containsKey(v);
    }

    @Override
    public boolean containsEdge(V v, V v2) {
        Assert.condition(this.dict.containsKey(v), "Vertex exists");
        Edge<V, Object> edge = new Edge<V, Object>(v, v2, null, this.directed);
        return this.dict.get(v).containsEdge(edge);
    }

    @Override
    public boolean visit(V v) {
        return this.dict.get(v).visit();
    }

    @Override
    public boolean visitEdge(Edge<V, E> edge) {
        return edge.visit();
    }

    @Override
    public boolean isVisited(V v) {
        return this.dict.get(v).isVisited();
    }

    @Override
    public boolean isVisitedEdge(Edge<V, E> edge) {
        return edge.isVisited();
    }

    @Override
    public void reset() {
        for (GraphListVertex<V, E> object2 : this.dict.values()) {
            object2.reset();
        }
        Iterator<Edge<V, E>> iterator = this.edges();
        while (iterator.hasNext()) {
            Edge<V, E> edge = iterator.next();
            edge.reset();
        }
    }

    @Override
    public int size() {
        return this.dict.size();
    }

    @Override
    public int degree(V v) {
        Assert.condition(this.dict.containsKey(v), "Vertex exists.");
        return this.dict.get(v).degree();
    }

    @Override
    public abstract int edgeCount();

    @Override
    public Iterator<V> iterator() {
        return this.dict.keySet().iterator();
    }

    @Override
    public Iterator<V> neighbors(V v) {
        Assert.condition(this.dict.containsKey(v), "Vertex exists");
        return this.dict.get(v).adjacentVertices();
    }

    @Override
    public Iterator<Edge<V, E>> edges() {
        return new GraphListEIterator<V, E>(this.dict);
    }

    @Override
    public void clear() {
        this.dict.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.dict.isEmpty();
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    public static void main(String[] stringArray) {
        int n;
        GraphListDirected<String, Double> graphListDirected = new GraphListDirected<String, Double>();
        SkewHeap<ComparableAssociation<Double, String>> skewHeap = new SkewHeap<ComparableAssociation<Double, String>>();
        String[] stringArray2 = new String[]{"TCL 312", "Images Cinema", "Movie Plex 3", "Cinema 1,2,&3", "Cinema 7", "Berkshire Mall Cinemas", "Hathaway's Drive Inn Theatre", "Hollywood Drive-In Theatre"};
        double[] dArray = new double[]{-1.0, 0.0, 12.6, 12.9, 12.9, 14.7, 16.5, 18.0};
        for (n = 0; n < stringArray2.length; ++n) {
            graphListDirected.add(stringArray2[n]);
        }
        for (n = 1; n < dArray.length; ++n) {
            graphListDirected.addEdge(stringArray2[0], stringArray2[n], new Double(dArray[n]));
        }
        Object object = graphListDirected.neighbors(stringArray2[0]);
        while (object.hasNext()) {
            String string = object.next();
            Double d = (Double)graphListDirected.getEdge(stringArray2[0], string).label();
            skewHeap.add(new ComparableAssociation<Double, String>(d, string));
        }
        while (!skewHeap.isEmpty()) {
            object = (ComparableAssociation)skewHeap.remove();
            System.out.println((String)((Association)object).getValue() + " is " + ((Association)object).getKey() + " miles away.");
        }
    }
}

