/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractList;
import structure5.Assert;
import structure5.DoublyLinkedListIterator;
import structure5.DoublyLinkedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublyLinkedList<E>
extends AbstractList<E> {
    protected int count = 0;
    protected DoublyLinkedNode<E> head = null;
    protected DoublyLinkedNode<E> tail = null;

    @Override
    public void add(E e) {
        this.addFirst(e);
    }

    @Override
    public void addFirst(E e) {
        this.head = new DoublyLinkedNode<E>(e, this.head, null);
        if (this.tail == null) {
            this.tail = this.head;
        }
        ++this.count;
    }

    @Override
    public E removeFirst() {
        Assert.pre(!this.isEmpty(), "List is not empty.");
        DoublyLinkedNode doublyLinkedNode = this.head;
        this.head = this.head.next();
        if (this.head != null) {
            this.head.setPrevious(null);
        } else {
            this.tail = null;
        }
        doublyLinkedNode.setNext(null);
        --this.count;
        return doublyLinkedNode.value();
    }

    @Override
    public void addLast(E e) {
        this.tail = new DoublyLinkedNode<E>(e, null, this.tail);
        if (this.head == null) {
            this.head = this.tail;
        }
        ++this.count;
    }

    @Override
    public E removeLast() {
        Assert.pre(!this.isEmpty(), "List is not empty.");
        DoublyLinkedNode<E> doublyLinkedNode = this.tail;
        this.tail = this.tail.previous();
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.setNext(null);
        }
        --this.count;
        return doublyLinkedNode.value();
    }

    @Override
    public E getFirst() {
        return this.head.value();
    }

    @Override
    public E getLast() {
        return this.tail.value();
    }

    @Override
    public boolean contains(E e) {
        DoublyLinkedNode<E> doublyLinkedNode;
        for (doublyLinkedNode = this.head; doublyLinkedNode != null && !doublyLinkedNode.value().equals(e); doublyLinkedNode = doublyLinkedNode.next()) {
        }
        return doublyLinkedNode != null;
    }

    @Override
    public E remove(E e) {
        DoublyLinkedNode<E> doublyLinkedNode;
        for (doublyLinkedNode = this.head; doublyLinkedNode != null && !doublyLinkedNode.value().equals(e); doublyLinkedNode = doublyLinkedNode.next()) {
        }
        if (doublyLinkedNode != null) {
            if (doublyLinkedNode.previous() != null) {
                doublyLinkedNode.previous().setNext(doublyLinkedNode.next());
            } else {
                this.head = doublyLinkedNode.next();
            }
            if (doublyLinkedNode.next() != null) {
                doublyLinkedNode.next().setPrevious(doublyLinkedNode.previous());
            } else {
                this.tail = doublyLinkedNode.previous();
            }
            --this.count;
            return doublyLinkedNode.value();
        }
        return null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        this.tail = null;
        this.head = null;
        this.count = 0;
    }

    @Override
    public E get(int n) {
        if (n >= this.size()) {
            return null;
        }
        DoublyLinkedNode<E> doublyLinkedNode = this.head;
        while (n > 0) {
            doublyLinkedNode = doublyLinkedNode.next();
            --n;
        }
        return doublyLinkedNode.value();
    }

    @Override
    public E set(int n, E e) {
        if (n >= this.size()) {
            return null;
        }
        DoublyLinkedNode<E> doublyLinkedNode = this.head;
        while (n > 0) {
            doublyLinkedNode = doublyLinkedNode.next();
            --n;
        }
        E e2 = doublyLinkedNode.value();
        doublyLinkedNode.setValue(e);
        return e2;
    }

    @Override
    public void add(int n, E e) {
        Assert.pre(0 <= n && n <= this.size(), "Index in range.");
        if (n == 0) {
            this.addFirst(e);
        } else if (n == this.size()) {
            this.addLast(e);
        } else {
            DoublyLinkedNode<E> doublyLinkedNode = null;
            DoublyLinkedNode<E> doublyLinkedNode2 = this.head;
            while (n > 0) {
                doublyLinkedNode = doublyLinkedNode2;
                doublyLinkedNode2 = doublyLinkedNode2.next();
                --n;
            }
            DoublyLinkedNode<E> doublyLinkedNode3 = new DoublyLinkedNode<E>(e, doublyLinkedNode2, doublyLinkedNode);
            ++this.count;
            doublyLinkedNode.setNext(doublyLinkedNode3);
            doublyLinkedNode2.setPrevious(doublyLinkedNode3);
        }
    }

    @Override
    public E remove(int n) {
        Assert.pre(0 <= n && n < this.size(), "Index in range.");
        if (n == 0) {
            return this.removeFirst();
        }
        if (n == this.size() - 1) {
            return this.removeLast();
        }
        DoublyLinkedNode<E> doublyLinkedNode = null;
        DoublyLinkedNode<E> doublyLinkedNode2 = this.head;
        while (n > 0) {
            doublyLinkedNode = doublyLinkedNode2;
            doublyLinkedNode2 = doublyLinkedNode2.next();
            --n;
        }
        doublyLinkedNode.setNext(doublyLinkedNode2.next());
        doublyLinkedNode2.next().setPrevious(doublyLinkedNode);
        --this.count;
        return doublyLinkedNode2.value();
    }

    @Override
    public int indexOf(E e) {
        int n = 0;
        DoublyLinkedNode<E> doublyLinkedNode = this.head;
        while (doublyLinkedNode != null && !doublyLinkedNode.value().equals(e)) {
            doublyLinkedNode = doublyLinkedNode.next();
            ++n;
        }
        if (doublyLinkedNode == null) {
            return -1;
        }
        return n;
    }

    @Override
    public int lastIndexOf(E e) {
        int n = this.size() - 1;
        DoublyLinkedNode<E> doublyLinkedNode = this.tail;
        while (doublyLinkedNode != null && !doublyLinkedNode.value().equals(e)) {
            doublyLinkedNode = doublyLinkedNode.previous();
            --n;
        }
        if (doublyLinkedNode == null) {
            return -1;
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new DoublyLinkedListIterator<E>(this.head);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<DoublyLinkedList:");
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" " + iterator.next());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

