/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractList;
import structure5.Assert;
import structure5.CircularListIterator;
import structure5.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularList<E>
extends AbstractList<E> {
    protected Node<E> tail = null;
    protected int count = 0;

    @Override
    public void add(E e) {
        this.addFirst(e);
    }

    @Override
    public void addFirst(E e) {
        Node<E> node = new Node<E>(e);
        if (this.tail == null) {
            this.tail = node;
            this.tail.setNext(this.tail);
        } else {
            node.setNext(this.tail.next());
            this.tail.setNext(node);
        }
        ++this.count;
    }

    @Override
    public void addLast(E e) {
        this.addFirst(e);
        this.tail = this.tail.next();
    }

    @Override
    public E getFirst() {
        return this.tail.next().value();
    }

    @Override
    public E getLast() {
        return this.tail.value();
    }

    @Override
    public E removeFirst() {
        Node node = this.tail.next();
        if (this.tail == this.tail.next()) {
            this.tail = null;
        } else {
            this.tail.setNext(node.next());
            node.setNext(null);
        }
        --this.count;
        return node.value();
    }

    @Override
    public E removeLast() {
        Assert.pre(!this.isEmpty(), "list is not empty.");
        Node<E> node = this.tail;
        while (node.next() != this.tail) {
            node = node.next();
        }
        Node<E> node2 = this.tail;
        if (node == this.tail) {
            this.tail = null;
        } else {
            node.setNext(this.tail.next());
            this.tail = node;
        }
        --this.count;
        return node2.value();
    }

    @Override
    public boolean contains(E e) {
        Node<E> node;
        if (this.tail == null) {
            return false;
        }
        for (node = this.tail.next(); node != this.tail && !node.value().equals(e); node = node.next()) {
        }
        return node.value().equals(e);
    }

    @Override
    public E remove(E e) {
        if (this.tail == null) {
            return null;
        }
        Node node = this.tail.next();
        Node<E> node2 = this.tail;
        for (int i = 0; i < this.count && !node.value().equals(e); ++i) {
            node2 = node;
            node = node.next();
        }
        if (node.value().equals(e)) {
            if (this.tail == this.tail.next()) {
                this.tail = null;
            } else {
                if (node == this.tail) {
                    this.tail = node2;
                }
                node2.setNext(node2.next().next());
            }
            node.setNext(null);
            --this.count;
            return node.value();
        }
        return null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public E get(int n) {
        if (n >= this.size()) {
            return null;
        }
        Node<E> node = this.tail.next();
        while (n > 0) {
            node = node.next();
            --n;
        }
        return node.value();
    }

    protected Node<E> getTail() {
        return this.tail;
    }

    @Override
    public E set(int n, E e) {
        if (n >= this.size()) {
            return null;
        }
        Node<E> node = this.tail.next();
        while (n > 0) {
            node = node.next();
            --n;
        }
        E e2 = node.value();
        node.setValue(e);
        return e2;
    }

    @Override
    public void add(int n, E e) {
        Assert.pre(0 <= n && n <= this.size(), "Index in range.");
        if (n == 0) {
            this.addFirst(e);
        } else if (n == this.size()) {
            this.addLast(e);
        } else {
            Node<E> node = this.tail;
            Node<E> node2 = this.tail.next();
            while (n > 0) {
                node = node2;
                node2 = node2.next();
                --n;
            }
            Node<E> node3 = new Node<E>(e, node2);
            ++this.count;
            node.setNext(node3);
        }
    }

    @Override
    public E remove(int n) {
        Assert.pre(0 <= n && n < this.size(), "Index in range.");
        if (n == 0) {
            return this.removeFirst();
        }
        if (n == this.size() - 1) {
            return this.removeLast();
        }
        Node<E> node = this.tail;
        Node<E> node2 = this.tail.next();
        while (n > 0) {
            --n;
            node = node2;
            node2 = node2.next();
        }
        node.setNext(node2.next());
        --this.count;
        return node2.value();
    }

    @Override
    public int indexOf(E e) {
        int n = 0;
        Node<E> node = this.tail.next();
        while (node != null && !node.value().equals(e)) {
            node = node == this.tail ? null : node.next();
            ++n;
        }
        if (node == null) {
            return -1;
        }
        return n;
    }

    @Override
    public int lastIndexOf(E e) {
        int n = -1;
        int n2 = 0;
        Node<E> node = this.tail.next();
        while (node != null) {
            if (node.value().equals(e)) {
                n = n2;
            }
            node = node == this.tail ? null : node.next();
            ++n2;
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new CircularListIterator<E>(this.tail);
    }

    @Override
    public boolean isEmpty() {
        return this.tail == null;
    }

    @Override
    public void clear() {
        this.count = 0;
        this.tail = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<CircularList:");
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" " + iterator.next());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

