/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;
import structure5.Association;
import structure5.List;
import structure5.SinglyLinkedList;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChainedHashtableIterator<K, V>
extends AbstractIterator<Association<K, V>> {
    protected List<Association<K, V>> data;
    protected AbstractIterator<Association<K, V>> elements;

    public ChainedHashtableIterator(Vector<List<Association<K, V>>> vector) {
        int n = vector.size();
        this.data = new SinglyLinkedList<Association<K, V>>();
        for (int i = 0; i < n; ++i) {
            if (vector.get(i) == null) continue;
            List<Association<K, V>> list = vector.get(i);
            for (Association<K, V> association : list) {
                this.data.addFirst(association);
            }
        }
        this.elements = (AbstractIterator)this.data.iterator();
    }

    @Override
    public void reset() {
        this.elements.reset();
    }

    @Override
    public boolean hasNext() {
        return this.elements.hasNext();
    }

    @Override
    public Association<K, V> next() {
        return this.elements.next();
    }

    @Override
    public Association<K, V> get() {
        return this.elements.get();
    }
}

