/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractMap;
import structure5.Association;
import structure5.ChainedHashtableIterator;
import structure5.KeyIterator;
import structure5.List;
import structure5.Map;
import structure5.Set;
import structure5.SetList;
import structure5.SinglyLinkedList;
import structure5.Structure;
import structure5.ValueIterator;
import structure5.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedHashtable<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Iterable<V> {
    protected Vector<List<Association<K, V>>> data = new Vector();
    protected int count;

    public ChainedHashtable(int n) {
        this.data.setSize(n);
        this.count = 0;
    }

    public ChainedHashtable() {
        this(997);
    }

    @Override
    public void clear() {
        for (List<Association<K, V>> list : this.data) {
            if (list == null) continue;
            list.clear();
        }
        this.count = 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected List<Association<K, V>> locate(K k) {
        int n = Math.abs(k.hashCode() % this.data.size());
        if (this.data.get(n) == null) {
            this.data.set(n, new SinglyLinkedList());
        }
        return this.data.get(n);
    }

    @Override
    public boolean containsValue(V v) {
        for (V v2 : this) {
            if (!v.equals(v2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(K k) {
        List<Association<K, V>> list = this.locate(k);
        return list.contains(new Association<K, Object>(k, null));
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueIterator(new ChainedHashtableIterator<K, V>(this.data));
    }

    @Override
    public Set<K> keySet() {
        SetList setList = new SetList();
        KeyIterator keyIterator = new KeyIterator(new ChainedHashtableIterator<K, V>(this.data));
        while (keyIterator.hasNext()) {
            setList.add(keyIterator.next());
        }
        return setList;
    }

    @Override
    public Set<Association<K, V>> entrySet() {
        SetList<Association<K, V>> setList = new SetList<Association<K, V>>();
        ChainedHashtableIterator<K, V> chainedHashtableIterator = new ChainedHashtableIterator<K, V>(this.data);
        while (chainedHashtableIterator.hasNext()) {
            setList.add((Association<K, V>)chainedHashtableIterator.next());
        }
        return setList;
    }

    @Override
    public Structure<V> values() {
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        ValueIterator valueIterator = new ValueIterator(new ChainedHashtableIterator<K, V>(this.data));
        while (valueIterator.hasNext()) {
            singlyLinkedList.add(valueIterator.next());
        }
        return singlyLinkedList;
    }

    @Override
    public V get(K k) {
        List<Association<K, V>> list = this.locate(k);
        Association<K, Object> association = list.remove(new Association<K, Object>(k, null));
        if (association == null) {
            return null;
        }
        list.addFirst(association);
        return association.getValue();
    }

    public Iterator<K> keys() {
        return new KeyIterator(new ChainedHashtableIterator<K, V>(this.data));
    }

    @Override
    public V put(K k, V v) {
        List<Association<K, V>> list = this.locate(k);
        Association<K, V> association = new Association<K, V>(k, v);
        Association<K, V> association2 = list.remove(association);
        list.addFirst(association);
        if (association2 != null) {
            return association2.getValue();
        }
        ++this.count;
        return null;
    }

    @Override
    public V remove(K k) {
        List<Association<K, V>> list = this.locate(k);
        Association<K, Object> association = list.remove(new Association<K, Object>(k, null));
        if (association == null) {
            return null;
        }
        --this.count;
        return association.getValue();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ChainedHashtable:");
        ChainedHashtableIterator<K, V> chainedHashtableIterator = new ChainedHashtableIterator<K, V>(this.data);
        while (chainedHashtableIterator.hasNext()) {
            Association association = (Association)chainedHashtableIterator.next();
            stringBuffer.append(" " + association.getKey() + "=" + association.getValue());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

