/*
 * Decompiled with CFR 0.152.
 */
package structure5;

public class BitSet {
    protected final int bitsPerInt = 32;
    protected final int initialCapacity = 256;
    protected int[] data;
    protected int allocated;

    public BitSet() {
        this.clear(256);
    }

    public BitSet(int n) {
        this.clear(n);
    }

    public void add(int n) {
        this.extend(n);
        int n2 = this.indexOf(n);
        int n3 = this.offsetOf(n);
        int n4 = n2;
        this.data[n4] = this.data[n4] | 1 << n3;
    }

    public void remove(int n) {
        if (this.probe(n)) {
            int n2 = this.indexOf(n);
            int n3 = this.offsetOf(n);
            int n4 = n2;
            this.data[n4] = this.data[n4] & ~(1 << n3);
        }
    }

    public boolean contains(int n) {
        return this.probe(n) && 0 != (this.data[this.indexOf(n)] & 1 << this.offsetOf(n));
    }

    public void clear() {
        this.clear(256);
    }

    public void clear(int n) {
        this.allocated = (n + 32 - 1) / 32;
        this.data = new int[this.allocated];
        for (int i = 0; i < this.allocated; ++i) {
            this.data[i] = 0;
        }
    }

    public Object clone() {
        BitSet bitSet = new BitSet(this.allocated * 32);
        for (int i = 0; i < this.allocated; ++i) {
            bitSet.data[i] = this.data[i];
        }
        return bitSet;
    }

    public Object union(BitSet bitSet) {
        int n;
        int n2 = this.allocated;
        int n3 = bitSet.allocated;
        if (n2 < n3) {
            return bitSet.union(this);
        }
        BitSet bitSet2 = new BitSet(n2 * 32);
        for (n = 0; n < n3; ++n) {
            bitSet2.data[n] = this.data[n] | bitSet.data[n];
        }
        while (n < n2) {
            bitSet2.data[n] = this.data[n];
            ++n;
        }
        return bitSet2;
    }

    public Object intersection(BitSet bitSet) {
        int n = this.allocated;
        int n2 = bitSet.allocated;
        if (n < n2) {
            return bitSet.intersection(this);
        }
        BitSet bitSet2 = new BitSet(n2 * 32);
        for (int i = 0; i < n2; ++i) {
            bitSet2.data[i] = this.data[i] & bitSet.data[i];
        }
        return bitSet2;
    }

    public Object difference(BitSet bitSet) {
        int n = this.allocated;
        int n2 = bitSet.allocated;
        BitSet bitSet2 = new BitSet(n * 32);
        if (n <= n2) {
            for (int i = 0; i < n; ++i) {
                bitSet2.data[i] = this.data[i] & ~bitSet.data[i];
            }
        } else {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                bitSet2.data[n3] = this.data[n3] & ~bitSet.data[n3];
            }
            for (n3 = n2; n3 < n; ++n3) {
                bitSet2.data[n3] = this.data[n3];
            }
        }
        return bitSet2;
    }

    public boolean subset(BitSet bitSet) {
        int n = this.allocated;
        int n2 = bitSet.allocated;
        if (n <= n2) {
            for (int i = 0; i < n; ++i) {
                if (0 == (this.data[i] & ~bitSet.data[i])) continue;
                return false;
            }
        } else {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                if (0 == (this.data[n3] & ~bitSet.data[n3])) continue;
                return false;
            }
            for (n3 = n2; n3 < n; ++n3) {
                if (0 == this.data[n3]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.allocated; ++i) {
            if (this.data[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        int n;
        BitSet bitSet = (BitSet)object;
        int n2 = this.allocated;
        int n3 = bitSet.allocated;
        if (n2 < n3) {
            return bitSet.equals(this);
        }
        for (n = 0; n < n3; ++n) {
            if (this.data[n] == bitSet.data[n]) continue;
            return false;
        }
        for (n = n3; n < n2; ++n) {
            if (this.data[n] == 0) continue;
            return false;
        }
        return true;
    }

    protected int indexOf(int n) {
        return n / 32;
    }

    protected int offsetOf(int n) {
        return n % 32;
    }

    protected void extend(int n) {
        if (!this.probe(n)) {
            int n2;
            int n3;
            int n4 = this.indexOf(n);
            for (n3 = this.allocated; n3 <= n4; n3 *= 2) {
            }
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < this.allocated; ++n2) {
                nArray[n2] = this.data[n2];
            }
            for (n2 = this.allocated; n2 < n3; ++n2) {
                nArray[n2] = 0;
            }
            this.data = nArray;
            this.allocated = n3;
        }
    }

    protected boolean probe(int n) {
        int n2 = this.indexOf(n);
        return this.data.length > n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BitSet:");
        int n = 0;
        while (this.probe(n)) {
            if (this.contains(n)) {
                stringBuffer.append(" " + Integer.toString(n));
            }
            ++n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

