/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractIterator;
import structure5.Assert;
import structure5.BTInorderIterator;
import structure5.BTLevelorderIterator;
import structure5.BTPostorderIterator;
import structure5.BTPreorderIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTree<E> {
    protected E val;
    protected BinaryTree<E> parent;
    protected BinaryTree<E> left;
    protected BinaryTree<E> right;

    public BinaryTree() {
        this.val = null;
        this.parent = null;
        this.left = this.right = this;
    }

    public BinaryTree(E e) {
        Assert.pre(e != null, "Tree values must be non-null.");
        this.val = e;
        this.left = new BinaryTree<E>();
        this.right = this.left;
        this.setLeft(this.left);
        this.setRight(this.right);
    }

    public BinaryTree(E e, BinaryTree<E> binaryTree, BinaryTree<E> binaryTree2) {
        Assert.pre(e != null, "Tree values must be non-null.");
        this.val = e;
        if (binaryTree == null) {
            binaryTree = new BinaryTree<E>();
        }
        this.setLeft(binaryTree);
        if (binaryTree2 == null) {
            binaryTree2 = new BinaryTree<E>();
        }
        this.setRight(binaryTree2);
    }

    public BinaryTree<E> left() {
        return this.left;
    }

    public BinaryTree<E> right() {
        return this.right;
    }

    public BinaryTree<E> parent() {
        return this.parent;
    }

    public void setLeft(BinaryTree<E> binaryTree) {
        if (this.isEmpty()) {
            return;
        }
        if (this.left != null && this.left.parent() == this) {
            this.left.setParent(null);
        }
        this.left = binaryTree;
        this.left.setParent(this);
    }

    public void setRight(BinaryTree<E> binaryTree) {
        if (this.isEmpty()) {
            return;
        }
        if (this.right != null && this.right.parent() == this) {
            this.right.setParent(null);
        }
        this.right = binaryTree;
        this.right.setParent(this);
    }

    protected void setParent(BinaryTree<E> binaryTree) {
        if (!this.isEmpty()) {
            this.parent = binaryTree;
        }
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.left().size() + this.right().size() + 1;
    }

    public BinaryTree<E> root() {
        if (this.parent() == null) {
            return this;
        }
        return this.parent().root();
    }

    public int height() {
        if (this.isEmpty()) {
            return -1;
        }
        return 1 + Math.max(this.left.height(), this.right.height());
    }

    public int depth() {
        if (this.parent() == null) {
            return 0;
        }
        return 1 + this.parent.depth();
    }

    public boolean isFull() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.left().height() != this.right().height()) {
            return false;
        }
        return this.left().isFull() && this.right().isFull();
    }

    public boolean isEmpty() {
        return this.val == null;
    }

    public boolean isComplete() {
        if (this.isEmpty()) {
            return true;
        }
        int n = this.left().height();
        int n2 = this.right().height();
        boolean bl = this.left().isFull();
        boolean bl2 = this.right().isFull();
        boolean bl3 = this.left().isComplete();
        boolean bl4 = this.right().isComplete();
        if (bl && bl4 && n == n2) {
            return true;
        }
        return bl3 && bl2 && n == n2 + 1;
    }

    public boolean isBalanced() {
        if (this.isEmpty()) {
            return true;
        }
        return Math.abs(this.left().height() - this.right().height()) <= 1 && this.left().isBalanced() && this.right().isBalanced();
    }

    public Iterator<E> iterator() {
        return this.inorderIterator();
    }

    public AbstractIterator<E> preorderIterator() {
        return new BTPreorderIterator(this);
    }

    public AbstractIterator<E> inorderIterator() {
        return new BTInorderIterator(this);
    }

    public AbstractIterator<E> postorderIterator() {
        return new BTPostorderIterator(this);
    }

    public AbstractIterator<E> levelorderIterator() {
        return new BTLevelorderIterator(this);
    }

    protected void rotateRight() {
        BinaryTree<E> binaryTree = this.parent();
        BinaryTree<E> binaryTree2 = this.left();
        boolean bl = binaryTree != null;
        boolean bl2 = this.isLeftChild();
        this.setLeft(binaryTree2.right());
        binaryTree2.setRight(this);
        if (bl) {
            if (bl2) {
                binaryTree.setLeft(binaryTree2);
            } else {
                binaryTree.setRight(binaryTree2);
            }
        }
    }

    protected void rotateLeft() {
        BinaryTree<E> binaryTree = this.parent();
        BinaryTree<E> binaryTree2 = this.right();
        boolean bl = binaryTree != null;
        boolean bl2 = this.isRightChild();
        this.setRight(binaryTree2.left());
        binaryTree2.setLeft(this);
        if (bl) {
            if (bl2) {
                binaryTree.setRight(binaryTree2);
            } else {
                binaryTree.setLeft(binaryTree2);
            }
        }
    }

    public boolean isLeftChild() {
        if (this.parent() == null) {
            return false;
        }
        return this == this.parent().left();
    }

    public boolean isRightChild() {
        if (this.parent() == null) {
            return false;
        }
        return this == this.parent().right();
    }

    public E value() {
        return this.val;
    }

    public void setValue(E e) {
        this.val = e;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = this.left().hashCode() + this.right().hashCode();
        if (this.value() != null) {
            n += this.value().hashCode();
        }
        return n;
    }

    public String treeString() {
        String string = "";
        for (int i = 0; i < this.depth(); ++i) {
            string = string + "\t|";
        }
        string = string + "<" + this.val + " : " + this.getHand() + ">\n";
        if (!this.left.isEmpty()) {
            string = string + this.left.treeString();
        }
        if (!this.right.isEmpty()) {
            string = string + this.right.treeString();
        }
        return string;
    }

    private String getHand() {
        if (this.isRightChild()) {
            return "R";
        }
        if (this.isLeftChild()) {
            return "L";
        }
        return "Root";
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<BinaryTree: empty>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BinaryTree " + this.value());
        if (!this.left().isEmpty()) {
            stringBuffer.append(" " + this.left());
        } else {
            stringBuffer.append(" -");
        }
        if (!this.right().isEmpty()) {
            stringBuffer.append(" " + this.right());
        } else {
            stringBuffer.append(" -");
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

