/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Comparator;
import java.util.Iterator;
import structure5.AbstractStructure;
import structure5.Assert;
import structure5.BinaryTree;
import structure5.NaturalComparator;
import structure5.OrderedStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySearchTree<E extends Comparable<E>>
extends AbstractStructure<E>
implements OrderedStructure<E> {
    protected BinaryTree<E> root;
    protected final BinaryTree<E> EMPTY = new BinaryTree();
    protected int count = 0;
    protected Comparator<E> ordering;

    public BinarySearchTree() {
        this(new NaturalComparator());
    }

    public BinarySearchTree(Comparator<E> comparator) {
        this.root = this.EMPTY;
        this.ordering = comparator;
    }

    @Override
    public boolean isEmpty() {
        return this.root == this.EMPTY;
    }

    @Override
    public void clear() {
        this.root = new BinaryTree();
        this.count = 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public int height() {
        return this.root.height();
    }

    protected BinaryTree<E> locate(BinaryTree<E> binaryTree, E e) {
        Comparable comparable = (Comparable)binaryTree.value();
        if (comparable.equals(e)) {
            return binaryTree;
        }
        BinaryTree<E> binaryTree2 = this.ordering.compare(comparable, e) < 0 ? binaryTree.right() : binaryTree.left();
        if (binaryTree2.isEmpty()) {
            return binaryTree;
        }
        return this.locate(binaryTree2, e);
    }

    protected BinaryTree<E> predecessor(BinaryTree<E> binaryTree) {
        Assert.pre(!binaryTree.isEmpty(), "No predecessor to middle value.");
        Assert.pre(!binaryTree.left().isEmpty(), "Root has left child.");
        BinaryTree<E> binaryTree2 = binaryTree.left();
        while (!binaryTree2.right().isEmpty()) {
            binaryTree2 = binaryTree2.right();
        }
        return binaryTree2;
    }

    protected BinaryTree<E> successor(BinaryTree<E> binaryTree) {
        Assert.pre(!binaryTree.isEmpty(), "Tree is non-null.");
        Assert.pre(!binaryTree.right().isEmpty(), "Root has right child.");
        BinaryTree<E> binaryTree2 = binaryTree.right();
        while (!binaryTree2.left().isEmpty()) {
            binaryTree2 = binaryTree2.left();
        }
        return binaryTree2;
    }

    @Override
    public void add(E e) {
        BinaryTree<E> binaryTree = new BinaryTree<E>(e, this.EMPTY, this.EMPTY);
        if (this.root.isEmpty()) {
            this.root = binaryTree;
        } else {
            BinaryTree<E> binaryTree2 = this.locate(this.root, e);
            Comparable comparable = (Comparable)binaryTree2.value();
            if (this.ordering.compare(comparable, e) < 0) {
                binaryTree2.setRight(binaryTree);
            } else if (!binaryTree2.left().isEmpty()) {
                this.predecessor(binaryTree2).setRight(binaryTree);
            } else {
                binaryTree2.setLeft(binaryTree);
            }
        }
        ++this.count;
    }

    @Override
    public boolean contains(E e) {
        if (this.root.isEmpty()) {
            return false;
        }
        BinaryTree<E> binaryTree = this.locate(this.root, e);
        return e.equals(binaryTree.value());
    }

    public E get(E e) {
        if (this.root.isEmpty()) {
            return null;
        }
        BinaryTree<E> binaryTree = this.locate(this.root, e);
        if (e.equals(binaryTree.value())) {
            return (E)((Comparable)binaryTree.value());
        }
        return null;
    }

    @Override
    public E remove(E e) {
        if (this.isEmpty()) {
            return null;
        }
        if (e.equals(this.root.value())) {
            BinaryTree<E> binaryTree = this.removeTop(this.root);
            --this.count;
            Comparable comparable = (Comparable)this.root.value();
            this.root = binaryTree;
            return (E)comparable;
        }
        BinaryTree<E> binaryTree = this.locate(this.root, e);
        if (e.equals(binaryTree.value())) {
            --this.count;
            BinaryTree<E> binaryTree2 = binaryTree.parent();
            if (binaryTree2.right() == binaryTree) {
                binaryTree2.setRight(this.removeTop(binaryTree));
            } else {
                binaryTree2.setLeft(this.removeTop(binaryTree));
            }
            return (E)((Comparable)binaryTree.value());
        }
        return null;
    }

    protected BinaryTree<E> removeTop(BinaryTree<E> binaryTree) {
        BinaryTree<E> binaryTree2 = binaryTree.left();
        BinaryTree<E> binaryTree3 = binaryTree.right();
        binaryTree.setLeft(this.EMPTY);
        binaryTree.setRight(this.EMPTY);
        if (binaryTree2.isEmpty()) {
            return binaryTree3;
        }
        if (binaryTree3.isEmpty()) {
            return binaryTree2;
        }
        BinaryTree<E> binaryTree4 = binaryTree2.right();
        if (binaryTree4.isEmpty()) {
            binaryTree2.setRight(binaryTree3);
            return binaryTree2;
        }
        BinaryTree<E> binaryTree5 = binaryTree2;
        while (!binaryTree4.right().isEmpty()) {
            binaryTree5 = binaryTree4;
            binaryTree4 = binaryTree4.right();
        }
        binaryTree5.setRight(binaryTree4.left());
        binaryTree4.setLeft(binaryTree2);
        binaryTree4.setRight(binaryTree3);
        return binaryTree4;
    }

    @Override
    public Iterator<E> iterator() {
        return this.root.inorderIterator();
    }

    @Override
    public int hashCode() {
        return this.root.hashCode();
    }

    public String treeString() {
        return this.root.treeString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BinarySearchTree:");
        if (!this.root.isEmpty()) {
            stringBuffer.append(this.root);
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

