/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;
import structure5.BinaryTree;
import structure5.Stack;
import structure5.StackList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTPreorderIterator<E>
extends AbstractIterator<E> {
    protected BinaryTree<E> root;
    protected Stack<BinaryTree<E>> todo = new StackList<BinaryTree<E>>();

    public BTPreorderIterator(BinaryTree<E> binaryTree) {
        this.root = binaryTree;
        this.reset();
    }

    @Override
    public void reset() {
        this.todo.clear();
        if (this.root != null) {
            this.todo.push(this.root);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    @Override
    public E get() {
        return this.todo.get().value();
    }

    @Override
    public E next() {
        BinaryTree<E> binaryTree = this.todo.pop();
        E e = binaryTree.value();
        if (!binaryTree.right().isEmpty()) {
            this.todo.push(binaryTree.right());
        }
        if (!binaryTree.left().isEmpty()) {
            this.todo.push(binaryTree.left());
        }
        return e;
    }
}

