/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;
import structure5.BinaryTree;
import structure5.Stack;
import structure5.StackList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTPostorderIterator<E>
extends AbstractIterator<E> {
    protected BinaryTree<E> root;
    protected Stack<BinaryTree<E>> todo = new StackList<BinaryTree<E>>();

    public BTPostorderIterator(BinaryTree<E> binaryTree) {
        this.root = binaryTree;
        this.reset();
    }

    @Override
    public void reset() {
        this.todo.clear();
        BinaryTree<E> binaryTree = this.root;
        while (!binaryTree.isEmpty()) {
            this.todo.push(binaryTree);
            if (!binaryTree.left().isEmpty()) {
                binaryTree = binaryTree.left();
                continue;
            }
            binaryTree = binaryTree.right();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    @Override
    public E get() {
        return this.todo.get().value();
    }

    @Override
    public E next() {
        BinaryTree<E> binaryTree;
        BinaryTree<E> binaryTree2 = this.todo.pop();
        E e = binaryTree2.value();
        if (!this.todo.isEmpty() && binaryTree2 == (binaryTree = this.todo.get()).left()) {
            binaryTree2 = binaryTree.right();
            while (!binaryTree2.isEmpty()) {
                this.todo.push(binaryTree2);
                if (!binaryTree2.left().isEmpty()) {
                    binaryTree2 = binaryTree2.left();
                    continue;
                }
                binaryTree2 = binaryTree2.right();
            }
        }
        return e;
    }
}

