/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;
import structure5.BinaryTree;
import structure5.Queue;
import structure5.QueueList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTLevelorderIterator<E>
extends AbstractIterator<E> {
    protected BinaryTree<E> root;
    protected Queue<BinaryTree<E>> todo = new QueueList<BinaryTree<E>>();

    public BTLevelorderIterator(BinaryTree<E> binaryTree) {
        this.root = binaryTree;
        this.reset();
    }

    @Override
    public void reset() {
        this.todo.clear();
        if (!this.root.isEmpty()) {
            this.todo.enqueue(this.root);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    @Override
    public E get() {
        return this.todo.get().value();
    }

    @Override
    public E next() {
        BinaryTree<E> binaryTree = this.todo.dequeue();
        E e = binaryTree.value();
        if (!binaryTree.left().isEmpty()) {
            this.todo.enqueue(binaryTree.left());
        }
        if (!binaryTree.right().isEmpty()) {
            this.todo.enqueue(binaryTree.right());
        }
        return e;
    }
}

