/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;
import structure5.BinaryTree;
import structure5.Stack;
import structure5.StackList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTInorderIterator<E>
extends AbstractIterator<E> {
    protected BinaryTree<E> root;
    protected Stack<BinaryTree<E>> todo = new StackList<BinaryTree<E>>();

    public BTInorderIterator(BinaryTree<E> binaryTree) {
        this.root = binaryTree;
        this.reset();
    }

    @Override
    public void reset() {
        this.todo.clear();
        BinaryTree<E> binaryTree = this.root;
        while (!binaryTree.isEmpty()) {
            this.todo.push(binaryTree);
            binaryTree = binaryTree.left();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    @Override
    public E get() {
        return this.todo.get().value();
    }

    @Override
    public E next() {
        BinaryTree<E> binaryTree = this.todo.pop();
        E e = binaryTree.value();
        if (!binaryTree.right().isEmpty()) {
            BinaryTree<E> binaryTree2 = binaryTree.right();
            do {
                this.todo.push(binaryTree2);
            } while (!(binaryTree2 = binaryTree2.left()).isEmpty());
        }
        return e;
    }
}

