/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import structure5.AbstractIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator<E>
extends AbstractIterator<E> {
    protected E[] data;
    protected int head;
    protected int count;
    protected int current;
    protected int remaining;

    public ArrayIterator(Object[] objectArray) {
        this(objectArray, 0, objectArray.length);
    }

    public ArrayIterator(Object[] objectArray, int n, int n2) {
        this.data = objectArray;
        this.head = n;
        this.count = n2;
        this.reset();
    }

    @Override
    public void reset() {
        this.current = this.head;
        this.remaining = this.count;
    }

    @Override
    public boolean hasNext() {
        return this.remaining > 0;
    }

    @Override
    public E next() {
        E e = this.data[this.current];
        this.current = (this.current + 1) % this.data.length;
        --this.remaining;
        return e;
    }

    @Override
    public E get() {
        return this.data[this.current];
    }

    public static void main(String[] stringArray) {
        String string = "For loops are much faster than iterators";
        Object[] objectArray = new String[10000000];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = string;
        }
        long l = System.nanoTime();
        ArrayIterator arrayIterator = new ArrayIterator(objectArray);
        while (arrayIterator.hasNext()) {
            arrayIterator.next();
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        System.out.println("Iteration over array took " + l3 + " nanoseconds to perform.");
        l = System.nanoTime();
        for (int i = 0; i < objectArray.length; ++i) {
        }
        l2 = System.nanoTime();
        long l4 = l2 - l;
        System.out.println("Looping over array took " + (l2 - l) + " nanoseconds to perform.");
        System.out.println("Iterators are " + (double)l3 / (double)l4 + " times " + "slower than loops.");
    }
}

