/*
 * Decompiled with CFR 0.152.
 */
package structure5;

import java.util.Iterator;
import structure5.AbstractStructure;
import structure5.Set;
import structure5.SinglyLinkedList;
import structure5.Structure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSet<E>
extends AbstractStructure<E>
implements Set<E> {
    @Override
    public void addAll(Structure<E> structure) {
        Iterator<E> iterator = structure.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean containsAll(Structure<E> structure) {
        Iterator<E> iterator = structure.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeAll(Structure<E> structure) {
        Iterator<E> iterator = structure.iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
    }

    @Override
    public void retainAll(Structure<E> structure) {
        SinglyLinkedList<E> singlyLinkedList = new SinglyLinkedList<E>();
        for (E e : structure) {
            if (structure.contains(e)) continue;
            singlyLinkedList.add(e);
        }
        while (!singlyLinkedList.isEmpty()) {
            this.remove(singlyLinkedList.removeFirst());
        }
    }
}

