/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import objectdraw.AWTDrawingCanvas;
import objectdraw.Controller;
import objectdraw.DrawingCanvas;
import objectdraw.Location;

public class WindowController
extends Controller
implements MouseListener,
MouseMotionListener {
    protected DrawingCanvas canvas = new AWTDrawingCanvas();
    private boolean redraw_needed;

    public void init() {
        this.redraw_needed = false;
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        super.setup();
        this.add((Component)((Object)this.canvas), "Center");
        this.canvas.repaint();
        this.validate();
        this.begin();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.canvas.disableAutoRepaint();
        this.redraw_needed = true;
        this.onMouseClick(new Location(mouseEvent.getPoint()));
        if (this.redraw_needed) {
            this.validate();
            this.canvas.repaint();
        }
        this.canvas.enableAutoRepaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.canvas.disableAutoRepaint();
        this.redraw_needed = true;
        this.onMousePress(new Location(mouseEvent.getPoint()));
        if (this.redraw_needed) {
            this.validate();
            this.canvas.repaint();
        }
        this.canvas.enableAutoRepaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.canvas.disableAutoRepaint();
        this.redraw_needed = true;
        this.onMouseRelease(new Location(mouseEvent.getPoint()));
        if (this.redraw_needed) {
            this.validate();
            this.canvas.repaint();
        }
        this.canvas.enableAutoRepaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.canvas.disableAutoRepaint();
        this.redraw_needed = true;
        this.onMouseEnter(new Location(mouseEvent.getPoint()));
        if (this.redraw_needed) {
            this.validate();
            this.canvas.repaint();
        }
        this.canvas.enableAutoRepaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.canvas.disableAutoRepaint();
        this.redraw_needed = true;
        this.onMouseExit(new Location(mouseEvent.getPoint()));
        if (this.redraw_needed) {
            this.validate();
            this.canvas.repaint();
        }
        this.canvas.enableAutoRepaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.canvas.disableAutoRepaint();
        this.redraw_needed = true;
        this.onMouseDrag(new Location(mouseEvent.getPoint()));
        if (this.redraw_needed) {
            this.validate();
            this.canvas.repaint();
        }
        this.canvas.enableAutoRepaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.canvas.disableAutoRepaint();
        this.redraw_needed = true;
        this.onMouseMove(new Location(mouseEvent.getPoint()));
        if (this.redraw_needed) {
            this.validate();
            this.canvas.repaint();
        }
        this.canvas.enableAutoRepaint();
    }

    public void onMouseClick(Location location) {
        this.redraw_needed = false;
    }

    public void onMousePress(Location location) {
        this.redraw_needed = false;
    }

    public void onMouseRelease(Location location) {
        this.redraw_needed = false;
    }

    public void onMouseEnter(Location location) {
        this.redraw_needed = false;
    }

    public void onMouseExit(Location location) {
        this.redraw_needed = false;
    }

    public void onMouseDrag(Location location) {
        this.redraw_needed = false;
    }

    public void onMouseMove(Location location) {
        this.redraw_needed = false;
    }
}

