/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.util.Date;
import objectdraw.Bounds;
import objectdraw.CanvasManager;
import objectdraw.DrawingCanvas;
import objectdraw.Location;
import objectdraw.Resizable2D;

public class VisibleImage
extends Resizable2D {
    protected Image image;
    private Image current;
    private CanvasManager canvasContent;
    private Location origin;
    private int width;
    private int height;

    public VisibleImage(Image image, Location location, DrawingCanvas drawingCanvas) {
        if (image == null || drawingCanvas == null) {
            if (image == null) {
                System.out.println("ERROR:  Image parameter to VisibleImage constructor is undefined");
            } else {
                System.out.println("ERROR:  DrawingCanvas parameter to VisibleImage constructor is undefined");
            }
        }
        this.canvas = drawingCanvas;
        this.canvasContent = this.canvas.getCanvasContent();
        this.origin = new Location(location);
        this.image = image;
        this.current = image;
        this.canvas.prepareImage(this.current, this.canvas);
        this.height = image.getHeight(this.canvas);
        this.width = image.getWidth(this.canvas);
        this.addToCanvas(this.canvas);
    }

    public VisibleImage(Image image, double d, double d2, DrawingCanvas drawingCanvas) {
        this(image, new Location(d, d2), drawingCanvas);
    }

    public VisibleImage(Image image, Location location, int n, int n2, DrawingCanvas drawingCanvas) {
        this(image, location, drawingCanvas);
        this.setBounds(new Bounds(location, n, n2));
    }

    public VisibleImage(Image image, double d, double d2, int n, int n2, DrawingCanvas drawingCanvas) {
        this(image, new Location(d, d2), n, n2, drawingCanvas);
    }

    public synchronized void draw(Graphics graphics) {
        if (this.origin != null) {
            super.draw(graphics);
            Point point = this.origin.toPoint();
            graphics.drawImage(this.current, point.x, point.y, this.canvas);
        }
    }

    public synchronized void moveTo(Location location) {
        this.origin = new Location(location);
        this.setStateChanged();
    }

    public synchronized void moveTo(double d, double d2) {
        this.moveTo(new Location(d, d2));
    }

    public synchronized void move(double d, double d2) {
        this.origin.translate(d, d2);
        this.setStateChanged();
    }

    public synchronized Bounds getBounds() {
        if (this.width == -1) {
            this.loadImage();
        }
        this.width = this.current.getWidth(this.canvas);
        this.height = this.current.getHeight(this.canvas);
        return new Bounds(this.origin, this.width, this.height);
    }

    public synchronized void setBounds(Bounds bounds) {
        this.origin = bounds.getLocation();
        this.height = (int)Math.rint(bounds.getHeight());
        this.width = (int)Math.rint(bounds.getWidth());
        this.current = this.image.getScaledInstance(this.width, this.height, 1);
        if (this.canvasContent != null) {
            this.canvas.prepareImage(this.current, this.canvas);
            this.setStateChanged();
        }
    }

    public synchronized void setWidth(double d) {
        this.width = (int)d;
        this.current = this.image.getScaledInstance(this.width, this.height, 1);
        this.canvas.prepareImage(this.current, this.canvas);
        this.setStateChanged();
    }

    public synchronized void setHeight(double d) {
        this.height = (int)d;
        this.current = this.image.getScaledInstance(this.width, this.height, 1);
        this.canvas.prepareImage(this.current, this.canvas);
        this.setStateChanged();
    }

    public double getWidth() {
        while (this.width == -1) {
            this.loadImage();
        }
        return this.width;
    }

    public double getHeight() {
        while (this.height == -1) {
            this.loadImage();
        }
        return this.height;
    }

    public void loadImage() {
        MediaTracker mediaTracker = new MediaTracker((Component)((Object)this.canvas));
        Date date = new Date();
        try {
            mediaTracker.addImage(this.current, 0);
            mediaTracker.waitForAll();
            this.height = this.current.getHeight(this.canvas);
            this.width = this.current.getWidth(this.canvas);
        }
        catch (InterruptedException interruptedException) {}
    }
}

