/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import objectdraw.Bounds;
import objectdraw.Drawable2D;
import objectdraw.DrawingCanvas;
import objectdraw.Location;

public class Text
extends Drawable2D {
    protected Location origin;
    protected double width;
    protected double height;
    protected double baseHeight;
    protected Font font;
    protected String text;

    public Text(Object object, Location location, DrawingCanvas drawingCanvas) {
        this.text = object.toString();
        this.origin = new Location(location);
        this.addToCanvas(drawingCanvas);
        this.changeSize();
    }

    public Text(boolean bl, Location location, DrawingCanvas drawingCanvas) {
        this(String.valueOf(bl), location, drawingCanvas);
    }

    public Text(char c, Location location, DrawingCanvas drawingCanvas) {
        this(String.valueOf(c), location, drawingCanvas);
    }

    public Text(long l, Location location, DrawingCanvas drawingCanvas) {
        this(String.valueOf(l), location, drawingCanvas);
    }

    public Text(double d, Location location, DrawingCanvas drawingCanvas) {
        this(String.valueOf(d), location, drawingCanvas);
    }

    public Text(Object object, double d, double d2, DrawingCanvas drawingCanvas) {
        this(String.valueOf(String.valueOf(object)), new Location(d, d2), drawingCanvas);
    }

    public Text(boolean bl, double d, double d2, DrawingCanvas drawingCanvas) {
        this(String.valueOf(bl), new Location(d, d2), drawingCanvas);
    }

    public Text(long l, double d, double d2, DrawingCanvas drawingCanvas) {
        this(String.valueOf(l), new Location(d, d2), drawingCanvas);
    }

    public Text(double d, double d2, double d3, DrawingCanvas drawingCanvas) {
        this(String.valueOf(d), new Location(d2, d3), drawingCanvas);
    }

    public Text(char c, double d, double d2, DrawingCanvas drawingCanvas) {
        this(String.valueOf(c), new Location(d, d2), drawingCanvas);
    }

    public synchronized void draw(Graphics graphics) {
        if (this.origin != null) {
            super.draw(graphics);
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            Point point = this.origin.toPoint();
            graphics.drawString(this.text, point.x, point.y + (int)Math.rint(this.baseHeight));
            graphics.setFont(font);
        }
    }

    protected synchronized void changeSize() {
        if (this.canvas != null) {
            Graphics graphics = this.canvas.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            this.width = fontMetrics.stringWidth(this.text);
            this.baseHeight = fontMetrics.getMaxAscent();
            this.height = this.baseHeight + (double)fontMetrics.getMaxDescent();
            fontMetrics = null;
            graphics.dispose();
        }
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public synchronized Bounds getBounds() {
        double d = this.origin.getX();
        double d2 = this.origin.getY();
        Bounds bounds = new Bounds(d, d2, this.width, this.height);
        return bounds;
    }

    public synchronized void moveTo(Location location) {
        this.origin = new Location(location);
        this.setStateChanged();
    }

    public synchronized void move(double d, double d2) {
        this.origin.translate(d, d2);
        this.setStateChanged();
    }

    public synchronized Font getFont() {
        if (this.font == null) {
            Graphics graphics = this.canvas.getGraphics();
            this.font = graphics.getFont();
        }
        return this.font;
    }

    public synchronized void setText(String string) {
        this.text = string;
        this.changeSize();
        this.canvasContent.setStateChanged();
    }

    public synchronized void setText(long l) {
        this.text = String.valueOf(l);
        this.changeSize();
        this.setStateChanged();
    }

    public synchronized void setText(boolean bl) {
        this.text = String.valueOf(bl);
        this.changeSize();
        this.setStateChanged();
    }

    public synchronized void setText(char c) {
        this.text = String.valueOf(c);
        this.changeSize();
        this.setStateChanged();
    }

    public synchronized void setText(double d) {
        this.text = String.valueOf(d);
        this.changeSize();
        this.setStateChanged();
    }

    public synchronized void setText(Object object) {
        this.text = object.toString();
        this.changeSize();
        this.setStateChanged();
    }

    public synchronized void setFont(Font font) {
        this.font = font;
        this.changeSize();
        this.setStateChanged();
    }

    public synchronized void setFont(String string) {
        this.setFont(new Font(string, this.getFont().getStyle(), this.getFont().getSize()));
    }

    public synchronized void setFontSize(int n) {
        this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), n));
    }

    public synchronized void setItalic() {
        this.setFont(new Font(this.getFont().getName(), 2, this.getFont().getSize()));
    }

    public synchronized void setBold() {
        this.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
    }

    public synchronized void setPlain() {
        this.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
    }

    public String toString() {
        return "Text at " + this.origin + " text:" + this.text + " font:" + this.getFont().toString() + " color:" + this.getColor().toString();
    }
}

