/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import objectdraw.Bounds;
import objectdraw.Location;
import objectdraw.Resizable2D;

public class Rect
extends Resizable2D {
    protected Location origin;
    protected double width;
    protected double height;

    public Rect(Location location, double d, double d2) {
        this.origin = new Location(location);
        this.width = d;
        this.height = d2;
    }

    public Rect(double d, double d2, double d3, double d4) {
        this.origin = new Location(d, d2);
        this.width = d3;
        this.height = d4;
    }

    public Rect(Location location, Location location2) {
        this.width = location2.getX() - location.getX();
        this.height = location2.getY() - location.getY();
        if (this.width < 0.0) {
            if (this.height < 0.0) {
                this.origin = new Location(location2);
                this.height = -this.height;
            } else {
                location.translate(this.width, 0.0);
                this.origin = new Location(location);
            }
            this.width = -this.width;
        } else if (this.height < 0.0) {
            this.origin = new Location(location);
            this.origin.translate(0.0, this.height);
            this.height = -this.height;
        } else {
            this.origin = new Location(location);
        }
    }

    public synchronized Bounds getBounds() {
        if (this.origin == null) {
            return null;
        }
        return new Bounds(this.origin.getX(), this.origin.getY(), this.width, this.height);
    }

    public synchronized void setBounds(Bounds bounds) {
        this.origin = bounds.getLocation();
        this.width = bounds.getWidth();
        this.height = bounds.getHeight();
        this.setStateChanged();
    }

    public synchronized void setWidth(double d) {
        this.width = d;
        this.setStateChanged();
    }

    public synchronized void setHeight(double d) {
        this.height = d;
        this.setStateChanged();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

