/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Point;
import java.io.Serializable;

public class Location
implements Serializable {
    private double x;
    private double y;

    public Location(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Location(Location location) {
        this(location.x, location.y);
    }

    public Location(Point point) {
        this(point.x, point.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public synchronized double distanceTo(Location location) {
        return Math.sqrt(Math.pow(location.x - this.x, 2.0) + Math.pow(location.y - this.y, 2.0));
    }

    public synchronized Point toPoint() {
        return new Point((int)Math.rint(this.x), (int)Math.rint(this.y));
    }

    public synchronized void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public String toString() {
        return "Location[" + this.x + "," + this.y + "]";
    }
}

