/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Graphics;
import java.awt.Point;
import objectdraw.Drawable;
import objectdraw.DrawingCanvas;
import objectdraw.Location;

public class Line
extends Drawable {
    public static final double CONTAINMENT_ECCENTRICITY = 0.999;
    protected Location start;
    protected Location end;

    public Line(Location location, Location location2, DrawingCanvas drawingCanvas) {
        this.start = new Location(location);
        this.end = new Location(location2);
        this.addToCanvas(drawingCanvas);
    }

    public Line(double d, double d2, double d3, double d4, DrawingCanvas drawingCanvas) {
        this(new Location(d, d2), new Location(d3, d4), drawingCanvas);
    }

    public synchronized void draw(Graphics graphics) {
        if (this.start != null && this.end != null) {
            super.draw(graphics);
            Point point = this.start.toPoint();
            Point point2 = this.end.toPoint();
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    public synchronized boolean contains(Location location) {
        double d;
        double d2;
        double d3;
        double d4 = location.distanceTo(this.start);
        return d4 + (d3 = location.distanceTo(this.end)) <= (d2 = 2.001001001001001 * (d = 0.5 * this.start.distanceTo(this.end)));
    }

    public Location getStart() {
        return this.start;
    }

    public Location getEnd() {
        return this.end;
    }

    public synchronized void setStart(Location location) {
        this.start = new Location(location);
        this.setStateChanged();
    }

    public synchronized void setEnd(Location location) {
        this.end = new Location(location);
        this.setStateChanged();
    }

    public synchronized void setEndPoints(Location location, Location location2) {
        this.setStart(location);
        this.setEnd(location2);
    }

    public synchronized void setEndPoints(double d, double d2, double d3, double d4) {
        this.setStart(new Location(d, d2));
        this.setEnd(new Location(d3, d4));
    }

    public String toString() {
        return "Line from " + this.start + " to " + this.end + " color:" + this.getColor().toString();
    }

    public synchronized void moveTo(Location location) {
        this.moveTo(location.getX(), location.getY());
    }

    public synchronized void moveTo(double d, double d2) {
        this.move(d - this.start.getX(), d2 - this.start.getY());
    }

    public synchronized void move(double d, double d2) {
        this.start.translate(d, d2);
        this.end.translate(d, d2);
        this.setStateChanged();
    }
}

