/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Graphics;
import java.awt.Rectangle;
import objectdraw.Bounds;
import objectdraw.DrawingCanvas;
import objectdraw.Location;
import objectdraw.Rect;

public class FramedOval
extends Rect {
    public FramedOval(Location location, double d, double d2, DrawingCanvas drawingCanvas) {
        super(location, d, d2);
        this.addToCanvas(drawingCanvas);
    }

    public FramedOval(double d, double d2, double d3, double d4, DrawingCanvas drawingCanvas) {
        super(d, d2, d3, d4);
        this.addToCanvas(drawingCanvas);
    }

    public FramedOval(Location location, Location location2, DrawingCanvas drawingCanvas) {
        super(location, location2);
        this.addToCanvas(drawingCanvas);
    }

    public synchronized boolean contains(Location location) {
        Bounds bounds = this.getBounds();
        double d = bounds.getWidth() / 2.0;
        double d2 = bounds.getHeight() / 2.0;
        double d3 = bounds.getX() + d;
        double d4 = bounds.getY() + d2;
        double d5 = location.getX() - d3;
        double d6 = location.getY() - d4;
        if (d == 0.0 || d2 == 0.0) {
            return false;
        }
        return d5 * d5 / (d * d) + d6 * d6 / (d2 * d2) <= 1.0;
    }

    public synchronized void draw(Graphics graphics) {
        Bounds bounds = this.getBounds();
        if (bounds != null) {
            super.draw(graphics);
            Rectangle rectangle = bounds.toRectangle();
            graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public String toString() {
        Bounds bounds = this.getBounds();
        Location location = bounds.getLocation();
        return "FramedOval at " + location.getX() + "," + location.getY() + " width:" + bounds.getWidth() + " height:" + bounds.getHeight() + " color:" + this.getColor().toString();
    }
}

