/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Graphics;
import java.awt.Rectangle;
import objectdraw.Bounds;
import objectdraw.DrawingCanvas;
import objectdraw.Location;
import objectdraw.Rect;

public class FilledRoundedRect
extends Rect {
    private int arcwidth = 0;
    private int archeight = 0;

    public FilledRoundedRect(Location location, double d, double d2, double d3, double d4, DrawingCanvas drawingCanvas) {
        super(location, d, d2);
        this.arcwidth = (int)d3;
        this.archeight = (int)d4;
        this.addToCanvas(drawingCanvas);
    }

    public FilledRoundedRect(double d, double d2, double d3, double d4, double d5, double d6, DrawingCanvas drawingCanvas) {
        this(new Location(d, d2), d3, d4, d5, d6, drawingCanvas);
    }

    public FilledRoundedRect(Location location, Location location2, double d, double d2, DrawingCanvas drawingCanvas) {
        this(location, location2.getX() - location.getX(), location2.getY() - location.getY(), d, d2, drawingCanvas);
    }

    public double getArcWidth() {
        return this.arcwidth;
    }

    public double getArcHeight() {
        return this.archeight;
    }

    public synchronized void setArcWidth(double d) {
        this.arcwidth = (int)d;
        this.setStateChanged();
    }

    public synchronized boolean contains(Location location) {
        Bounds bounds = this.getBounds();
        double d = bounds.getWidth();
        double d2 = bounds.getHeight();
        double d3 = Math.abs((double)this.arcwidth > d ? d / 2.0 : (double)(this.arcwidth / 2));
        double d4 = Math.abs((double)this.archeight > d2 ? d2 / 2.0 : (double)(this.arcwidth / 2));
        double d5 = bounds.getX() + d3;
        double d6 = bounds.getY() + d4;
        double d7 = d5;
        double d8 = bounds.getY() + d2 - d4;
        double d9 = bounds.getX() + d - d3;
        double d10 = d6;
        double d11 = d9;
        double d12 = d8;
        Bounds bounds2 = new Bounds(d5, bounds.getY(), d - 2.0 * d3, d2);
        Bounds bounds3 = new Bounds(bounds.getX(), d6, d, d2 - 2.0 * d4);
        return bounds2.contains(location) || bounds3.contains(location) || this.cornerContains(d5, d6, d3, d4, location) || this.cornerContains(d7, d8, d3, d4, location) || this.cornerContains(d9, d10, d3, d4, location) || this.cornerContains(d11, d12, d3, d4, location);
    }

    private synchronized boolean cornerContains(double d, double d2, double d3, double d4, Location location) {
        double d5 = d - location.getX();
        double d6 = d2 - location.getY();
        if (d3 == 0.0 || d4 == 0.0) {
            return false;
        }
        return d5 * d5 / (d3 * d3) + d6 * d6 / (d4 * d4) <= 1.0;
    }

    public synchronized void setArcHeight(double d) {
        this.archeight = (int)d;
        this.setStateChanged();
    }

    public synchronized void draw(Graphics graphics) {
        Bounds bounds = this.getBounds();
        if (bounds != null) {
            super.draw(graphics);
            Rectangle rectangle = this.getBounds().toRectangle();
            graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.arcwidth, this.archeight);
        }
    }

    public String toString() {
        Bounds bounds = this.getBounds();
        Location location = bounds.getLocation();
        return "FilledRoundedRect at " + location.getX() + "," + location.getY() + " width:" + bounds.getWidth() + " height:" + bounds.getHeight() + " arcwidth:" + this.arcwidth + " archeight:" + this.archeight + " color:" + this.getColor().toString();
    }
}

