/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Graphics;
import java.awt.Rectangle;
import objectdraw.Bounds;
import objectdraw.DrawingCanvas;
import objectdraw.Location;
import objectdraw.Rect;

public class FilledRect
extends Rect {
    public FilledRect(Location location, double d, double d2, DrawingCanvas drawingCanvas) {
        super(location, d, d2);
        this.addToCanvas(drawingCanvas);
    }

    public FilledRect(double d, double d2, double d3, double d4, DrawingCanvas drawingCanvas) {
        super(d, d2, d3, d4);
        this.addToCanvas(drawingCanvas);
    }

    public FilledRect(Location location, Location location2, DrawingCanvas drawingCanvas) {
        super(location, location2);
        this.addToCanvas(drawingCanvas);
    }

    public synchronized void draw(Graphics graphics) {
        Bounds bounds = this.getBounds();
        if (bounds != null) {
            super.draw(graphics);
            Rectangle rectangle = bounds.toRectangle();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public String toString() {
        Bounds bounds = this.getBounds();
        Location location = bounds.getLocation();
        return "FilledRect at " + location.getX() + "," + location.getY() + " width:" + bounds.getWidth() + " height:" + bounds.getHeight() + " color:" + this.getColor().toString();
    }
}

